/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.scene.multiple;

import com.bxm.game.scene.common.core.DefaultErrGen;
import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.bean.GameException;
import com.bxm.game.scene.common.core.prop.AcquiredPropLog;
import com.bxm.game.scene.common.core.prop.Prop;
import com.bxm.game.scene.common.core.prop.PropBuilder;
import com.bxm.game.scene.common.core.prop.PropService;
import com.bxm.game.scene.common.core.scene.AbstractSceneService;
import com.bxm.game.scene.common.core.scene.AcquiringOrMultiplyPropEvent;
import com.bxm.game.scene.common.core.scene.multiple.MultipleConditional;
import com.bxm.game.scene.common.core.scene.multiple.MultipleSceneEvent;
import com.bxm.game.scene.common.core.scene.multiple.MultipleSceneRequest;
import com.bxm.game.scene.common.core.scene.multiple.MultipleSceneResponse;
import com.bxm.game.scene.common.core.user.TemporaryAtomicService;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class MultipleSceneServiceImpl
extends AbstractSceneService<MultipleSceneRequest, MultipleSceneResponse>
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(MultipleSceneServiceImpl.class);
    private final BigDecimal ONE = new BigDecimal("1");
    private final String ACQUIRED_NUM = "acquiredNum";
    private final Map<String, MultipleConditional> condtionalMap = Maps.newHashMap();
    private final PropService propService;
    private final TemporaryAtomicService temporaryAtomicService;
    private final PropBuilder propBuilder;

    public MultipleSceneServiceImpl(PropService propService, TemporaryAtomicService temporaryAtomicService, PropBuilder propBuilder) {
        this.propService = propService;
        this.temporaryAtomicService = temporaryAtomicService;
        this.propBuilder = propBuilder;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        Map beans = event.getApplicationContext().getBeansOfType(MultipleConditional.class);
        for (Map.Entry e : beans.entrySet()) {
            MultipleConditional bean = (MultipleConditional)e.getValue();
            String conditionSceneType = bean.getSceneType();
            this.condtionalMap.put(conditionSceneType, bean);
            log.info("Registered MultipleConditional bean: {}", (Object)bean);
        }
    }

    @Override
    public boolean isMultipleGrant() {
        return true;
    }

    @Override
    protected String createId(MultipleSceneRequest request) {
        return request.getId();
    }

    @Override
    protected Prop takeProp(MultipleSceneRequest request, Map<Object, Object> attach) {
        Number multipleNum;
        if (Objects.isNull(request)) {
            return null;
        }
        String appId = AppContext.get().getAppId();
        String uid = AppContext.get().getUid();
        String id = request.getId();
        String barrier = this.getSceneType() + id;
        if (this.temporaryAtomicService.incrAndAbove(barrier, 1L)) {
            throw new GameException(DefaultErrGen.NOT_MEET_ACQUIRING_CONDITION);
        }
        AcquiredPropLog takeLog = this.propService.getTakeLog(id);
        if (Objects.isNull(takeLog)) {
            return null;
        }
        if (!StringUtils.equals((String)appId, (String)takeLog.getAppId()) || !StringUtils.equals((String)uid, (String)takeLog.getUid()) || takeLog.isCompletedMultiple() || !(takeLog.getMultipleNum().doubleValue() > 1.0)) {
            return null;
        }
        if (this.condtionalMap.containsKey(takeLog.getSceneType()) && !this.condtionalMap.get(takeLog.getSceneType()).checked(takeLog)) {
            this.temporaryAtomicService.incrBy(barrier, -1L);
            throw new GameException(DefaultErrGen.NOT_MEET_MULTIPLE_CONDITION);
        }
        boolean acquired = takeLog.isAcquired();
        Number number = multipleNum = acquired ? (Number)new BigDecimal(takeLog.getMultipleNum().toString()).subtract(this.ONE).doubleValue() : (Number)takeLog.getMultipleNum();
        if (multipleNum.doubleValue() <= 0.0) {
            return null;
        }
        Prop prop = this.propBuilder.rebuild(takeLog.getAssetType(), takeLog.getPropNum(), multipleNum, takeLog.getAct(), takeLog.getSceneType());
        if (Objects.isNull(prop)) {
            return null;
        }
        this.propService.saveTakeLog(takeLog.setAcquired(true).setCompletedMultiple(true));
        int acquiredNum = acquired ? Math.round((float)prop.propNum() * (prop.multipleNum().floatValue() + 1.0f)) : Math.round((float)prop.propNum() * prop.multipleNum().floatValue());
        attach.put("acquiredNum", acquiredNum);
        return prop;
    }

    @Override
    protected MultipleSceneResponse createResponse(MultipleSceneRequest request, String id, Prop prop, Map<Object, Object> attach) {
        MultipleSceneResponse response = new MultipleSceneResponse();
        response.setAcquiredNum(TypeHelper.castToInt((Object)attach.get("acquiredNum")));
        return response;
    }

    @Override
    protected void afterCompletion(MultipleSceneRequest request, MultipleSceneResponse response, Prop prop, Map<Object, Object> attach) {
        this.getSyncEventPark().post((EventObject)new MultipleSceneEvent(this, request, response, prop.getSceneType()));
        this.getSyncEventPark().post((EventObject)new AcquiringOrMultiplyPropEvent(this, request, response, prop.getSceneType(), this.getSceneType()));
    }

    @Override
    public String getSceneType() {
        return "multiple";
    }

    @Override
    public Class<MultipleSceneRequest> getRequestClass() {
        return MultipleSceneRequest.class;
    }
}

