/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.user.dao;

import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.user.DefaultTimeBoundService;
import com.bxm.game.scene.common.core.user.dao.UserDao;
import com.bxm.warcar.utils.DateHelper;
import java.util.Date;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpStatus;

@ConditionalOnMissingBean(value={UserDao.class})
public class EmptyUserDaoImpl
implements UserDao {
    private static final Logger log = LoggerFactory.getLogger(EmptyUserDaoImpl.class);
    protected final int BOUND_TTL = 1296000;
    protected final String ANCHOR_FORMAT = "yyyyMMdd";
    @Autowired(required=false)
    protected DefaultTimeBoundService defaultTimeBoundService;

    @Override
    public boolean handleAppContext(HttpServletRequest request, HttpServletResponse response, AppContext context) {
        this.boundDays(context, -1);
        return true;
    }

    protected boolean error(HttpServletResponse response) {
        response.setStatus(HttpStatus.ACCEPTED.value());
        return false;
    }

    protected void boundDays(AppContext context, int days) {
        this.boundDays(context, days, -1);
    }

    protected void boundDays(AppContext context, int days, int ttlDays) {
        int cycleSeconds = days < 1 ? -1 : 86400 * days;
        int ttl = ttlDays < 1 ? 1296000 : 86400 * ttlDays;
        this.boundSeconds(context, ttl, "yyyyMMdd", cycleSeconds);
    }

    private void boundSeconds(AppContext context, int ttl, String format, int cycleSeconds) {
        this.boundAnchor(context, ttl, format, anchor -> {
            if (cycleSeconds < 1) {
                return false;
            }
            long limitTime = DateUtils.addSeconds((Date)DateHelper.parse((String)anchor, (String)format), (int)cycleSeconds).getTime();
            return System.currentTimeMillis() > limitTime;
        });
    }

    protected void boundExpDate(AppContext context, Date expDate) {
        this.boundExpDate(context, expDate, -1);
    }

    protected void boundExpDate(AppContext context, Date expDate, int ttlDays) {
        int ttl = ttlDays < 1 ? 1296000 : 86400 * ttlDays;
        this.boundExpDate(context, ttl, "yyyyMMdd", expDate);
    }

    private void boundExpDate(AppContext context, int ttl, String format, Date expDate) {
        this.boundAnchor(context, ttl, format, anchor -> {
            if (null == expDate) {
                return false;
            }
            return System.currentTimeMillis() > expDate.getTime();
        });
    }

    private void boundAnchor(AppContext context, int ttl, String format, Predicate<String> predicate) {
        String boundAnchor = this.defaultTimeBoundService.saveGetAnchor(ttl, predicate, () -> DateHelper.format((String)format));
        context.setBoundAnchor(boundAnchor);
        context.setBoundTtl(ttl);
    }
}

