/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.user.redis;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.Key;
import com.bxm.game.scene.common.core.user.AbstractOriginalService;
import com.bxm.game.scene.common.core.util.CommonHelper;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public abstract class BaseOriginalServiceImpl
implements AbstractOriginalService {
    private static final Logger log = LoggerFactory.getLogger(BaseOriginalServiceImpl.class);
    protected final AppConfigFetcher appConfigFetcher;
    protected final Key key;
    protected final Fetcher fetcher;
    protected final Counter counter;
    protected final Updater updater;

    public BaseOriginalServiceImpl(AppConfigFetcher appConfigFetcher, Key key, Fetcher fetcher, Updater updater, Counter counter) {
        this.appConfigFetcher = appConfigFetcher;
        this.key = key;
        this.fetcher = fetcher;
        this.counter = counter;
        this.updater = updater;
    }

    @Override
    public Long ttl(KeyGenerator key) {
        JedisPool jedisPool = CommonHelper.getJedisPool(this.fetcher);
        try (Jedis jedis = jedisPool.getResource();){
            Long l = jedis.ttl(key.generateKey());
            return l;
        }
    }

    @Override
    public void expire(KeyGenerator key, int ttl) {
        this.updater.expire(key, ttl);
    }

    @Override
    public long get(KeyGenerator key, long defaultValue) {
        return (Long)Optional.ofNullable(this.fetcher.fetch(key, Long.class)).orElse(defaultValue);
    }

    @Override
    public <T> T get(KeyGenerator key, Class<T> clazz) {
        return (T)this.fetcher.fetch(key, clazz);
    }

    @Override
    public void set(KeyGenerator key, Object value, int ttl) {
        this.updater.update(key, value, ttl);
    }

    @Override
    public long incrBy(KeyGenerator key, long value, int ttl) {
        return Optional.ofNullable(this.counter.incrementByAndGet(key, value, ttl)).orElse(0L);
    }

    @Override
    public boolean incrBy(KeyGenerator key, long value, Predicate<Long> predicate, int ttl) {
        long l = this.incrBy(key, value, ttl);
        return predicate.test(l);
    }

    @Override
    public void del(KeyGenerator key) {
        this.updater.remove(key);
    }

    @Override
    public long hGet(KeyGenerator key, String field, long defaultValue) {
        return (Long)Optional.ofNullable(this.fetcher.hfetch(key, field, Long.class)).orElse(defaultValue);
    }

    @Override
    public <T> T hGet(KeyGenerator key, String field, Class<T> clazz) {
        return (T)this.fetcher.hfetch(key, field, clazz);
    }

    @Override
    public Map<String, Object> hGetAll(KeyGenerator key) {
        return this.fetcher.hfetchall(key, Object.class);
    }

    @Override
    public <T> Map<String, T> hGetAll(KeyGenerator key, Class<T> clazz) {
        return this.fetcher.hfetchall(key, clazz);
    }

    @Override
    public void hSet(KeyGenerator key, String field, Object value, int ttl) {
        this.updater.hupdate(key, field, value, ttl);
    }

    @Override
    public long hIncrBy(KeyGenerator key, String field, long value, int ttl) {
        return Optional.ofNullable(this.counter.hincrementByAndGet(key, field, value, ttl)).orElse(0L);
    }

    @Override
    public boolean hIncrBy(KeyGenerator key, String field, long value, Predicate<Long> predicate, int ttl) {
        long l = this.hIncrBy(key, field, value, ttl);
        return predicate.test(l);
    }

    @Override
    public void hDel(KeyGenerator key, String ... field) {
        this.updater.hremove(key, field);
    }

    @Override
    public void setbit(KeyGenerator key, long offset, boolean value, int ttl) {
        if (offset < 0L) {
            log.error("setbit 'offset': greater than or equal to 0");
            return;
        }
        JedisPool jedisPool = CommonHelper.getJedisPool(this.fetcher);
        try (Jedis jedis = jedisPool.getResource();){
            String keyStr = key.generateKey();
            jedis.setbit(keyStr, offset, value);
            if (ttl > 0) {
                jedis.expire(keyStr, ttl);
            }
        }
    }

    @Override
    public long bitcount(KeyGenerator key) {
        JedisPool jedisPool = CommonHelper.getJedisPool(this.fetcher);
        try (Jedis jedis = jedisPool.getResource();){
            long l = jedis.bitcount(key.generateKey());
            return l;
        }
    }
}

