/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.user.redis;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.Key;
import com.bxm.game.scene.common.core.user.BaseTimeBoundService;
import com.bxm.game.scene.common.core.user.TodayAtomicService;
import com.bxm.game.scene.common.core.user.redis.BaseTypeServiceImpl;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTimeBoundServiceImpl
extends BaseTypeServiceImpl
implements BaseTimeBoundService {
    private static final Logger log = LoggerFactory.getLogger(BaseTimeBoundServiceImpl.class);
    protected List<String> IGNORE_BOUND_ANCHOR = new ArrayList<String>();
    protected final TodayAtomicService todayAtomicService;

    public BaseTimeBoundServiceImpl(AppConfigFetcher appConfigFetcher, Key key, Fetcher fetcher, Updater updater, Counter counter, TodayAtomicService todayAtomicService) {
        super(appConfigFetcher, key, fetcher, updater, counter);
        this.todayAtomicService = todayAtomicService;
        List<String> list = this.ignoreBoundAnchorTypes();
        if (null != list) {
            this.IGNORE_BOUND_ANCHOR = list;
        }
    }

    @Override
    public String saveGetAnchor(int ttl, Predicate<String> predicate, Supplier<String> supplier) {
        String anchor = this.get("anchor", String.class);
        if (StringUtils.isEmpty((CharSequence)anchor) || predicate.test(anchor)) {
            anchor = supplier.get();
            this.set("anchor", (Object)anchor, ttl);
        } else {
            this.forceUpdateTtl(ttl);
        }
        return anchor;
    }

    private void forceUpdateTtl(int ttl) {
        long count = this.todayAtomicService.hIncr("counter", "boundTypeTtl");
        if (count > 1L) {
            return;
        }
        List<String> types = this.appConfigFetcher.getBoundRedisKeyTypes();
        for (String type : types) {
            this.expire(type, ttl);
        }
    }
}

