/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.user.redis;

import com.bxm.game.scene.common.core.fun.system.RuntimeClock;
import com.bxm.game.scene.common.core.scene.event.AcquiredPropEvent;
import com.bxm.game.scene.common.core.user.DefaultTimeBoundService;
import com.bxm.game.scene.common.core.user.UserActiveService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

@ConditionalOnMissingBean(value={UserActiveService.class})
public class RedisUserActiveServiceImpl
implements UserActiveService {
    private static final Logger log = LoggerFactory.getLogger(RedisUserActiveServiceImpl.class);
    protected final DefaultTimeBoundService defaultTimeBoundService;
    protected final RuntimeClock runtimeClock;

    public RedisUserActiveServiceImpl(DefaultTimeBoundService defaultTimeBoundService, RuntimeClock runtimeClock) {
        this.defaultTimeBoundService = defaultTimeBoundService;
        this.runtimeClock = runtimeClock;
    }

    @Override
    public void active() {
        this.defaultTimeBoundService.setbit("active", this.runtimeClock.getRuntimeDays(), true);
    }

    @Override
    public void active(AcquiredPropEvent event) {
        this.defaultTimeBoundService.setbit("active", this.runtimeClock.getRuntimeDays(), true);
    }

    @Override
    public long getActiveDays() {
        return this.defaultTimeBoundService.bitcount("active");
    }

    @Override
    public void clean() {
        this.defaultTimeBoundService.del("active");
    }

    @Override
    public void reset(long days) {
        this.defaultTimeBoundService.del("active");
        long runtimeDays = this.runtimeClock.getRuntimeDays();
        if (runtimeDays < days) {
            this.runtimeClock.initStartingDate(days - 1L);
        }
        int offset = 1;
        while ((long)offset <= days) {
            this.defaultTimeBoundService.setbit("active", (long)offset, true);
            ++offset;
        }
    }
}

