/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.user.redis;

import com.bxm.game.scene.common.core.Key;
import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.user.UserRegisterService;
import com.bxm.game.scene.common.core.util.CommonHelper;
import com.bxm.warcar.cache.Fetcher;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;

public class RedisUserRegisterServiceImpl
implements UserRegisterService {
    private static final Logger log = LoggerFactory.getLogger(RedisUserRegisterServiceImpl.class);
    private final Key key;
    private final Fetcher fetcher;

    public RedisUserRegisterServiceImpl(Key key, @Qualifier(value="jedisFetcher") Fetcher fetcher) {
        this.key = key;
        this.fetcher = fetcher;
    }

    @Override
    public void register() {
        String gcode = AppContext.get().getGameCode();
        String appid = AppContext.get().getAppId();
        String uid = AppContext.get().getUid();
        int gcodeBucket = CommonHelper.getBuckets(gcode, 10);
        int appidBucket = CommonHelper.getBuckets(appid, 10);
        int uidBucket = CommonHelper.getBuckets(uid, 1000);
        JedisPool jedisPool = CommonHelper.getJedisPool(this.fetcher);
        double score = System.currentTimeMillis();
        try (Jedis jedis = jedisPool.getResource();){
            Pipeline pipeline = jedis.pipelined();
            pipeline.zadd(this.key.getRegisterGames(gcodeBucket).generateKey(), score, gcode);
            pipeline.zadd(this.key.getRegisterApps(appidBucket).generateKey(), score, appid);
            pipeline.zadd(this.key.getRegisterUsers(uidBucket).generateKey(), score, uid);
            pipeline.syncAndReturnAll();
        }
        catch (Exception e) {
            log.error("register error: appid={}, uid={}, e={}", new Object[]{appid, uid, ExceptionUtils.getStackTrace((Throwable)e)});
        }
    }
}

