/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.util;

import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.DateHelper;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.JedisPool;

public class CommonHelper {
    public static int orderDays() {
        return CommonHelper.orderDays(AppContext.get().getBoundAnchor(), new Date());
    }

    public static int orderDays(String startYmd, Date end) {
        Date start = DateHelper.parse((String)startYmd, (String)"yyyyMMdd");
        return CommonHelper.orderDays(start, end);
    }

    public static int orderDays(Date start, Date end) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(start);
        c1.set(11, 0);
        c1.set(12, 0);
        c1.set(13, 0);
        c1.set(14, 0);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(end);
        c2.set(11, 0);
        c2.set(12, 0);
        c2.set(13, 0);
        c2.set(14, 0);
        return (int)Math.round((double)(c2.getTimeInMillis() - c1.getTimeInMillis()) / 8.64E7) + 1;
    }

    public static int getBuckets(String str, int dividend) {
        return Math.abs(str.hashCode()) % dividend;
    }

    public static JedisPool getJedisPool(Fetcher fetcher) {
        return CommonHelper.getJedisPool(fetcher.getClientOriginal());
    }

    public static JedisPool getJedisPool(Updater updater) {
        return CommonHelper.getJedisPool(updater.getClientOriginal());
    }

    public static JedisPool getJedisPool(Counter counter) {
        return CommonHelper.getJedisPool(counter.getClientOriginal());
    }

    private static JedisPool getJedisPool(Object original) {
        if (!(original instanceof JedisPool)) {
            throw new RuntimeException("originalClient is not JedisPool!");
        }
        return (JedisPool)original;
    }

    public static String getConfigField(String gcode, String appid) {
        return StringUtils.join((Object[])new Serializable[]{gcode, Character.valueOf(':'), appid});
    }
}

