/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;

public class WeekCNHelper {
    public static int orderDaysOfWeek(Date date) {
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setTime(date);
        int days = cld.get(7);
        if (days == 1) {
            days = 8;
        }
        return days - 1;
    }

    public static List<Date> getDaysOfWeek(Date date) {
        int i;
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setTime(date);
        int days = cld.get(7);
        if (days == 1) {
            days = 8;
        }
        int minus = days - 2;
        int plus = 8 - days;
        ArrayList<Date> dates = new ArrayList<Date>();
        if (minus > 0) {
            for (i = minus; i > 0; --i) {
                dates.add(DateUtils.addDays((Date)date, (int)(-i)));
            }
        }
        dates.add(date);
        if (plus > 0) {
            for (i = 1; i <= plus; ++i) {
                dates.add(DateUtils.addDays((Date)date, (int)i));
            }
        }
        return dates;
    }

    public static String getWeekOfYear(Date date) {
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setFirstDayOfWeek(2);
        cld.setTime(date);
        cld.setMinimalDaysInFirstWeek(7);
        int year = cld.get(1);
        int days = cld.get(6);
        int weeks = cld.get(3);
        if (days < 7 && weeks > 50) {
            --year;
        }
        if (weeks > 9) {
            return StringUtils.join((Object[])new Object[]{year, weeks});
        }
        return StringUtils.join((Object[])new Object[]{year, 0, weeks});
    }
}

