/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.web;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.fun.header.RequestHeaderHandler;
import com.bxm.game.scene.common.core.user.UserRegisterService;
import com.bxm.game.scene.common.core.user.dao.UserDao;
import com.bxm.game.scene.common.core.web.interceptor.AppContextInterceptor;
import com.bxm.game.scene.common.core.web.interceptor.AppStatusInterceptor;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class GlobalMvcConfigurer
implements WebMvcConfigurer {
    private final AppConfigFetcher appConfigFetcher;
    private final RequestHeaderHandler requestHeaderHandler;
    private final UserDao userDao;
    private final UserRegisterService userRegisterService;

    public GlobalMvcConfigurer(AppConfigFetcher appConfigFetcher, RequestHeaderHandler requestHeaderHandler, UserDao userDao, UserRegisterService userRegisterService) {
        this.appConfigFetcher = appConfigFetcher;
        this.requestHeaderHandler = requestHeaderHandler;
        this.userDao = userDao;
        this.userRegisterService = userRegisterService;
    }

    @Bean
    public AppContextInterceptor appContextInterceptor() {
        return new AppContextInterceptor(this.userDao, this.requestHeaderHandler, this.userRegisterService, this.appConfigFetcher);
    }

    @Bean
    public AppStatusInterceptor appStatusInterceptor() {
        return new AppStatusInterceptor(this.appConfigFetcher);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        List<String> excludePathPatterns = this.appConfigFetcher.excludePathPatternsOfGlobal();
        registry.addInterceptor((HandlerInterceptor)this.appStatusInterceptor()).order(Integer.MIN_VALUE).addPathPatterns(new String[]{"/**"}).excludePathPatterns(excludePathPatterns);
        registry.addInterceptor((HandlerInterceptor)this.appContextInterceptor()).order(-2147483647).addPathPatterns(new String[]{"/**"}).excludePathPatterns(excludePathPatterns).excludePathPatterns(this.appConfigFetcher.excludePathPatternsOfAppContextInterceptor());
    }

    @Bean
    public CorsFilter corsFilter() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.addAllowedOrigin("*");
        configuration.addAllowedHeader("*");
        configuration.addAllowedMethod("*");
        configuration.setAllowCredentials(Boolean.valueOf(true));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return new CorsFilter((CorsConfigurationSource)source);
    }
}

