/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.web.controllers;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.assets.AssetService;
import com.bxm.game.scene.common.core.bean.enums.DataTypeEnum;
import com.bxm.game.scene.common.core.bean.vo.ArchiveVo;
import com.bxm.game.scene.common.core.fun.archives.CustomArchiveHandler;
import com.bxm.game.scene.common.core.fun.archives.CustomArchiveHandlerFactory;
import com.bxm.game.scene.common.core.scene.signin.continuous.ContinuousSigninService;
import com.bxm.game.scene.common.core.transfer.AssetArchiveTransfer;
import com.bxm.game.scene.common.core.transfer.DataTransfer;
import com.bxm.game.scene.common.core.user.DefaultTimeBoundService;
import com.bxm.game.scene.common.core.user.PermanentAtomicService;
import com.bxm.game.scene.common.core.user.TodayAtomicService;
import com.bxm.game.scene.common.core.user.UserActiveService;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/archive"})
public class ArchiveController {
    private static final Logger log = LoggerFactory.getLogger(ArchiveController.class);
    private final AppConfigFetcher appConfigFetcher;
    private final CustomArchiveHandlerFactory customArchiveHandlerFactory;
    private final DataTransfer dataTransfer;
    private final AssetArchiveTransfer assetArchiveTransfer;
    private final TodayAtomicService todayAtomicService;
    private final PermanentAtomicService permanentAtomicService;
    private final DefaultTimeBoundService defaultTimeBoundService;
    private final AssetService assetService;
    private final UserActiveService userActiveService;
    @Autowired(required=false)
    private ContinuousSigninService continuousSigninService;

    public ArchiveController(AppConfigFetcher appConfigFetcher, CustomArchiveHandlerFactory customArchiveHandlerFactory, DataTransfer dataTransfer, AssetArchiveTransfer assetArchiveTransfer, TodayAtomicService todayAtomicService, PermanentAtomicService permanentAtomicService, DefaultTimeBoundService defaultTimeBoundService, AssetService assetService, UserActiveService userActiveService) {
        this.appConfigFetcher = appConfigFetcher;
        this.customArchiveHandlerFactory = customArchiveHandlerFactory;
        this.dataTransfer = dataTransfer;
        this.assetArchiveTransfer = assetArchiveTransfer;
        this.todayAtomicService = todayAtomicService;
        this.permanentAtomicService = permanentAtomicService;
        this.defaultTimeBoundService = defaultTimeBoundService;
        this.assetService = assetService;
        this.userActiveService = userActiveService;
    }

    @GetMapping(value={"/fetch"})
    public ResponseEntity<ArchiveVo> fetch() {
        if (this.appConfigFetcher.activatingOnFetchArchive()) {
            this.userActiveService.active();
        }
        HashMap custom = Maps.newHashMap();
        ImmutableSet<CustomArchiveHandler> handlers = this.customArchiveHandlerFactory.getHandlers();
        for (CustomArchiveHandler handler : handlers) {
            String displayFieldName = handler.getDisplayFieldName();
            if (custom.containsKey(displayFieldName)) {
                log.warn("duplicated key: {}", (Object)displayFieldName);
            }
            custom.put(displayFieldName, handler.getArchiveObjects());
        }
        ArchiveVo.ArchiveVoBuilder builder = ArchiveVo.builder().today(this.dataTransfer.transfer(DataTypeEnum.TODAY, this.todayAtomicService.getAll())).permanent(this.dataTransfer.transfer(DataTypeEnum.PERMANENT, this.permanentAtomicService.getAll())).bound(this.dataTransfer.transfer(DataTypeEnum.BOUND, this.defaultTimeBoundService.getAll())).assets(this.assetArchiveTransfer.transfer(this.assetService.getAll())).custom(custom).time(System.currentTimeMillis());
        if (Objects.nonNull(this.continuousSigninService)) {
            builder.continuousSignInDays(this.continuousSigninService.getContinuousDays());
        }
        if (this.appConfigFetcher.showUserActiveDays()) {
            builder.activeDays(this.userActiveService.getActiveDays());
        }
        return ResponseEntity.ok((Object)builder.build());
    }
}

