/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.web.controllers;

import com.bxm.game.scene.common.core.fun.config.SceneConfigFetcher;
import com.bxm.game.scene.common.core.fun.config.SceneConfigServiceFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/config"})
public class ConfigController {
    private static final Logger log = LoggerFactory.getLogger(ConfigController.class);
    @Autowired
    private SceneConfigServiceFactory factory;

    @RequestMapping(value={"/info/{sceneType}"})
    public ResponseEntity<Object> info(@PathVariable(value="sceneType") String sceneType, HttpServletRequest request) {
        Map<String, Object> paramMap = this.getParamMap(request);
        SceneConfigFetcher configFetcher = this.factory.get(sceneType);
        if (null == configFetcher) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.ok(configFetcher.getConfig(paramMap));
    }

    private Map<String, Object> getParamMap(HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (MapUtils.isEmpty((Map)request.getParameterMap())) {
            return map;
        }
        Set entrySet = request.getParameterMap().entrySet();
        for (Map.Entry entry : entrySet) {
            String[] arr = (String[])entry.getValue();
            if (null == arr || arr.length < 1) continue;
            StringBuilder result = new StringBuilder();
            if (arr.length == 1) {
                result.append(arr[0]);
            } else {
                for (int i = 0; i < arr.length; ++i) {
                    result.append(arr[i]);
                    if (i >= arr.length - 1) continue;
                    result.append(",");
                }
            }
            map.put((String)entry.getKey(), result);
        }
        return map;
    }
}

