/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.web.controllers;

import com.bxm.game.scene.common.core.redeem.RedeemRequest;
import com.bxm.game.scene.common.core.redeem.RedeemResponse;
import com.bxm.game.scene.common.core.redeem.RedeemService;
import com.bxm.game.scene.common.core.redeem.dao.RedeemDao;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/redeem"})
@ConditionalOnBean(value={RedeemDao.class})
public class RedeemController {
    private final RedeemService redeemService;

    public RedeemController(RedeemService redeemService) {
        this.redeemService = redeemService;
    }

    @PostMapping(value={"/submit"})
    public ResponseEntity<String> submit(@Validated @RequestBody RedeemRequest request) {
        this.redeemService.redeem(request);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/log"})
    public ResponseEntity<List<RedeemResponse>> log() {
        return ResponseEntity.ok(this.redeemService.list());
    }
}

