/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.web.controllers;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.bean.GameException;
import com.bxm.game.scene.common.core.fun.action.SceneActionFetcher;
import com.bxm.game.scene.common.core.fun.action.SceneActionResponse;
import com.bxm.game.scene.common.core.fun.action.SceneActionServiceFactory;
import com.bxm.game.scene.common.core.scene.SceneRequest;
import com.bxm.game.scene.common.core.scene.SceneResponse;
import com.bxm.game.scene.common.core.scene.SceneService;
import com.bxm.game.scene.common.core.scene.SceneServiceFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/scene"})
public class SceneController {
    private static final Logger log = LoggerFactory.getLogger(SceneController.class);
    private final SceneServiceFactory factory;
    private final SceneActionServiceFactory actionFactory;
    private final AppConfigFetcher appConfigFetcher;

    public SceneController(SceneServiceFactory factory, SceneActionServiceFactory actionFactory, AppConfigFetcher appConfigFetcher) {
        this.factory = factory;
        this.actionFactory = actionFactory;
        this.appConfigFetcher = appConfigFetcher;
    }

    @PostMapping(value={"/take/{sceneType}"})
    public ResponseEntity<SceneResponse> take(@PathVariable(value="sceneType") String sceneType, @RequestBody(required=false) String message) {
        SceneService service = this.factory.get(sceneType);
        if (Objects.isNull(service)) {
            return ResponseEntity.badRequest().build();
        }
        Object request = service.convert(message);
        Object response = service.take(request);
        return ResponseEntity.ok(response);
    }

    @PostMapping(value={"/takes/{sceneType}"})
    public ResponseEntity<List<SceneResponse>> takes(@PathVariable(value="sceneType") String sceneType, @RequestBody(required=false) String message, HttpServletRequest httpRequest) {
        SceneService service = this.factory.get(sceneType);
        if (Objects.isNull(service)) {
            return ResponseEntity.badRequest().build();
        }
        List requests = service.convertList(message);
        if (CollectionUtils.isEmpty(requests)) {
            return ResponseEntity.badRequest().build();
        }
        ArrayList reps = new ArrayList();
        try {
            for (SceneRequest request : requests) {
                Object response = service.take(request);
                reps.add(response);
            }
        }
        catch (GameException e) {
            log.warn("takes warn: sceneType={},rqSize={},rsSize={},{}", new Object[]{sceneType, requests.size(), reps.size(), e.getErrCode()});
        }
        return ResponseEntity.ok(reps);
    }

    @PostMapping(value={"/action/{sceneType}"})
    public ResponseEntity<SceneActionResponse> action(@PathVariable(value="sceneType") String sceneType, @RequestBody(required=false) String message) {
        SceneActionFetcher service = this.actionFactory.get(sceneType);
        if (Objects.isNull(service)) {
            return ResponseEntity.badRequest().build();
        }
        Object request = service.convertAction(message);
        Object response = service.action(request);
        return ResponseEntity.ok(response);
    }
}

