/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.web.controllers;

import com.bxm.game.scene.common.core.DefaultErrGen;
import com.bxm.game.scene.common.core.bean.GameException;
import com.bxm.game.scene.common.core.bean.storage.StorageRequest;
import com.bxm.game.scene.common.core.user.DefaultTimeBoundService;
import com.bxm.game.scene.common.core.user.TodayAtomicService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/storage"})
public class StorageController {
    private static final Logger log = LoggerFactory.getLogger(StorageController.class);
    @Autowired
    private TodayAtomicService todayAtomicService;
    @Autowired
    private DefaultTimeBoundService defaultTimeBoundService;

    @PostMapping(value={"/today"})
    public ResponseEntity<Boolean> todaySet(@RequestBody StorageRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getKey()) || StringUtils.isBlank((CharSequence)request.getValue())) {
            throw new GameException(DefaultErrGen.BAD_REQUEST);
        }
        this.todayAtomicService.hSet("storage", request.getKey(), (Object)request.getValue());
        return ResponseEntity.ok((Object)Boolean.TRUE);
    }

    @GetMapping(value={"/today"})
    public ResponseEntity<Map> todayGet(@RequestParam(value="key") String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", key);
        map.put("value", this.todayAtomicService.hGet("storage", key, String.class));
        return ResponseEntity.ok(map);
    }

    @GetMapping(value={"/today/getAll"})
    public ResponseEntity<Map> todayGetAll() {
        Map<String, Object> map = this.todayAtomicService.hGetAll("storage", Object.class);
        return ResponseEntity.ok(map);
    }

    @PostMapping(value={"/bound"})
    public ResponseEntity<Boolean> boundSet(@RequestBody StorageRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getKey()) || StringUtils.isBlank((CharSequence)request.getValue())) {
            throw new GameException(DefaultErrGen.BAD_REQUEST);
        }
        this.defaultTimeBoundService.hSet("storage", request.getKey(), (Object)request.getValue());
        return ResponseEntity.ok((Object)Boolean.TRUE);
    }

    @GetMapping(value={"/bound"})
    public ResponseEntity<Map> boundGet(@RequestParam(value="key") String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", key);
        map.put("value", this.defaultTimeBoundService.hGet("storage", key, String.class));
        return ResponseEntity.ok(map);
    }

    @GetMapping(value={"/bound/getAll"})
    public ResponseEntity<Map> boundGetGetAll() {
        Map<String, Object> map = this.defaultTimeBoundService.hGetAll("storage", Object.class);
        return ResponseEntity.ok(map);
    }
}

