/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.web.controllers;

import com.bxm.game.scene.common.core.withdraw.WithdrawRequest;
import com.bxm.game.scene.common.core.withdraw.WithdrawResponse;
import com.bxm.game.scene.common.core.withdraw.WithdrawService;
import com.bxm.game.scene.common.core.withdraw.dao.WithdrawDao;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/withdraw"})
@ConditionalOnBean(value={WithdrawDao.class})
public class WithdrawController {
    private final WithdrawService withdrawService;

    public WithdrawController(WithdrawService withdrawService) {
        this.withdrawService = withdrawService;
    }

    @PostMapping(value={"/submit"})
    public ResponseEntity<String> submit(@Validated @RequestBody WithdrawRequest request) {
        this.withdrawService.withdraw(request);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/log"})
    public ResponseEntity<List<WithdrawResponse>> log() {
        return ResponseEntity.ok(this.withdrawService.list());
    }
}

