/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.web.interceptor;

import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.fun.header.RequestHeaderHandler;
import com.bxm.game.scene.common.core.user.UserRegisterService;
import com.bxm.game.scene.common.core.user.dao.UserDao;
import com.bxm.warcar.integration.dc.dot.Device;
import com.bxm.warcar.utils.IpHelper;
import com.bxm.warcar.utils.JsonHelper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;

public class AppContextInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AppContextInterceptor.class);
    private final String UNDEFINED = "undefined";
    private final String X_GCODE = "x-gcode";
    private final String X_APPID = "x-appid";
    private final String X_DEVICE = "x-device";
    private final String X_DID = "x-did";
    private final UserDao userDao;
    private final RequestHeaderHandler requestHeaderHandler;
    private final UserRegisterService userRegisterService;
    private final AppConfigFetcher appConfigFetcher;

    public AppContextInterceptor(UserDao userDao, RequestHeaderHandler requestHeaderHandler, UserRegisterService userRegisterService, AppConfigFetcher appConfigFetcher) {
        this.userDao = userDao;
        this.requestHeaderHandler = requestHeaderHandler;
        this.userRegisterService = userRegisterService;
        this.appConfigFetcher = appConfigFetcher;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String gcode = request.getHeader("x-gcode");
        String appid = request.getHeader("x-appid");
        String device = request.getHeader("x-device");
        String did = request.getHeader("x-did");
        if (this.checkHeadParam(response, gcode, appid, device)) {
            return false;
        }
        AppContext context = AppContext.getInstance();
        context.setGameCode(gcode).setAppId(appid).setXDevice(device).setDid(did);
        if (StringUtils.isNotBlank((String)did) && did.length() >= this.appConfigFetcher.didMinLength()) {
            Device deviceObject = Device.decrypt((String)did);
            context.setDevice(deviceObject);
            String newDevice = this.requestHeaderHandler.fetchDeviceValue(deviceObject);
            if (StringUtils.isBlank((String)newDevice)) {
                log.warn("newDevice is empty: appContext={}", (Object)JsonHelper.convert((Object)AppContext.getInstance()));
            }
            context.setDidDevice(newDevice);
            if (this.requestHeaderHandler.isOverrideDeviceValue(appid, device, deviceObject)) {
                if (!StringUtils.equals((String)newDevice, (String)device) && log.isDebugEnabled()) {
                    log.debug("{} Not equals, device is:{}, except: {}, but: {}", new Object[]{appid, JsonHelper.convert((Object)deviceObject), device, newDevice});
                }
                if (StringUtils.isNotBlank((String)newDevice)) {
                    device = newDevice;
                }
            }
        }
        context.setDevUid(device).setUid(device);
        boolean ret = this.userDao.handleAppContext(request, response, context);
        if (ret) {
            this.userRegisterService.register();
        }
        if (this.appConfigFetcher.debugIps().contains(IpHelper.getIpFromHeader((HttpServletRequest)request))) {
            log.info("AppContext={}", (Object)JsonHelper.convert((Object)context));
        }
        return ret;
    }

    private boolean checkHeadParam(HttpServletResponse response, String gcode, String appid, String device) {
        if (StringUtils.isBlank((String)gcode) || "undefined".equals(gcode)) {
            log.info("Required header name: 'gcode' is blank or undefined!");
            response.setStatus(HttpStatus.ACCEPTED.value());
            return true;
        }
        if (StringUtils.isBlank((String)appid) || "undefined".equals(appid)) {
            log.info("Required header name: 'appid' is blank or undefined!");
            response.setStatus(HttpStatus.ACCEPTED.value());
            return true;
        }
        if (StringUtils.isBlank((String)device) || "undefined".equals(device)) {
            log.info("Required header name: 'device' is blank or undefined!");
            response.setStatus(HttpStatus.ACCEPTED.value());
            return true;
        }
        return false;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        AppContext.remove();
    }
}

