/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.core.withdraw;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bxm.game.scene.common.core.AppConfigFetcher;
import com.bxm.game.scene.common.core.DefaultErrGen;
import com.bxm.game.scene.common.core.bean.AppContext;
import com.bxm.game.scene.common.core.bean.GameException;
import com.bxm.game.scene.common.core.withdraw.WithdrawRequest;
import com.bxm.game.scene.common.core.withdraw.WithdrawResponse;
import com.bxm.game.scene.common.core.withdraw.WithdrawService;
import com.bxm.game.scene.common.core.withdraw.dao.WithdrawDao;
import com.bxm.game.scene.common.dal.entity.PrizeLog;
import com.bxm.game.scene.common.dal.service.IPrizeLogService;
import com.bxm.warcar.id.IdGenerator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;

@ConditionalOnBean(value={WithdrawDao.class})
public class WithdrawServiceImpl
implements WithdrawService {
    private static final Logger log = LoggerFactory.getLogger(WithdrawServiceImpl.class);
    private final int STATUS_SUBMIT = 1;
    private final IPrizeLogService iPrizeLogService;
    private final AppConfigFetcher appConfigFetcher;
    private final IdGenerator id;
    private final WithdrawDao withdrawDao;

    public WithdrawServiceImpl(IPrizeLogService iPrizeLogService, AppConfigFetcher appConfigFetcher, IdGenerator id, WithdrawDao withdrawDao) {
        this.iPrizeLogService = iPrizeLogService;
        this.appConfigFetcher = appConfigFetcher;
        this.id = id;
        this.withdrawDao = withdrawDao;
    }

    @Override
    public void withdraw(WithdrawRequest request) {
        HashMap<Object, Object> attach = new HashMap<Object, Object>();
        if (!this.withdrawDao.check(request, attach)) {
            return;
        }
        this.withdrawDao.deduct(request, attach);
        Double yuan = this.withdrawDao.toYuan(request, attach);
        BigDecimal bd = new BigDecimal(String.valueOf(yuan));
        Double fen = yuan * 100.0;
        AppContext ctx = AppContext.get();
        PrizeLog prizeLog = new PrizeLog().setOrderId(this.id.next()).setGameCode(ctx.getGameCode()).setAppId(ctx.getAppId()).setUid(ctx.getUid()).setAppUid(Optional.ofNullable(ctx.getCuid()).orElse("")).setStatus(Integer.valueOf(1)).setPrizeId(Long.valueOf(0L)).setPrizeName(bd.setScale(2, RoundingMode.HALF_UP).toString()).setPrizeNum(Integer.valueOf(1)).setName(request.getName()).setMobile(request.getMobile()).setAddress("").setActivityType(this.appConfigFetcher.activityType()).setPayType(request.getPayType()).setAccount(request.getAccount()).setAmount(Integer.valueOf(fen.intValue()));
        this.withdrawDao.handlePrizeLog(prizeLog, attach);
        try {
            if (!this.iPrizeLogService.save((Object)prizeLog)) {
                throw new GameException(DefaultErrGen.WITHDRAW_ERR);
            }
            log.info("PrizeLog: {}", (Object)prizeLog);
        }
        catch (Exception e) {
            log.error("save: ", (Throwable)e);
            this.withdrawDao.rollback(request, attach);
            throw new GameException(DefaultErrGen.WITHDRAW_ERR);
        }
        this.withdrawDao.notifySuccess(request, attach, prizeLog);
    }

    @Override
    public List<WithdrawResponse> list() {
        QueryWrapper query = this.withdrawDao.getQuery();
        if (null == query) {
            AppContext ctx = AppContext.get();
            query = Wrappers.query((Object)new PrizeLog().setGameCode(ctx.getGameCode()).setAppId(ctx.getAppId()).setUid(ctx.getUid()).setActivityType(this.appConfigFetcher.activityType()));
            query.gt((Object)"amount", (Object)0);
        }
        return this.withdrawDao.getResponse(this.iPrizeLogService.list(query));
    }
}

