package com.bxm.game.scene.common.dal.enums;

/**
 * 资金流水枚举<br/>
 *
 * @author kerry.jiang
 * @date 2021/1/12 14:31
 */
public class EAssetsLog {

    /**
     * api调用状态<br/>
     *
     * @author kerry.jiang
     * @date 2021/1/12 14:31
     */
    public static enum ApiStatus {

        /**
         * 成功
         */
        SUCCESS(1, "成功"),
        /**
         * 错误
         */
        ERROR(2, "错误"),
        /**
         * 超时
         */
        TIMEOUT(3, "超时"),
        ;

        private int id;
        private String desc;

        private ApiStatus(int id, String desc){
            this.id = id;
            this.desc = desc;
        }

        public int getId() {
            return id;
        }

        public String getDesc() {
            return desc;
        }
    }

    /**
     * 资产操作状态<br/>
     *
     * @author kerry.jiang
     * @date 2021/1/7 16:40
     */
    public static enum OperateStatus {

        /**
         * 成功
         */
        SUCCESS(1, "成功"),
        /**
         * 失败
         */
        FAIL(2, "失败"),
        ;

        private final int id;
        private final String desc;

        private OperateStatus(int id, String desc){
            this.id = id;
            this.desc = desc;
        }

        public int getId() {
            return id;
        }

        public String getDesc() {
            return desc;
        }
    }

    /**
     * 资产操作类型<br/>
     *
     * @author kerry.jiang
     * @date 2021/1/7 16:40
     */
    public static enum OperateType {

        /**
         * 增加
         */
        PLUS(1, "增加"),
        /**
         * 扣除
         */
        MINUS(2, "扣除"),
        ;

        private final int id;
        private final String desc;

        private OperateType(int id, String desc){
            this.id = id;
            this.desc = desc;
        }

        public int getId() {
            return id;
        }

        public String getDesc() {
            return desc;
        }
    }
}
