package com.bxm.game.scene.common.dal.entity;

import java.time.LocalDateTime;
import com.bxm.game.scene.common.dal.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 资产镜像
 * </p>
 *
 * @author Allen Hu
 * @since 2021-11-23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class AssetsSnapshot extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 日期
     */
    private String rptDate;

    /**
     * 活动类型
     */
    private String activityType;

    /**
     * 游戏代码
     */
    private String gameCode;

    /**
     * appid
     */
    private String appId;

    /**
     * 变现猫用户ID
     */
    private String uid;

    /**
     * app用户ID
     */
    private String appUid;

    /**
     * 资产类型
     */
    private String assetType;

    /**
     * 资产数量
     */
    private Integer assetNum;

    /**
     * 同步时间
     */
    private LocalDateTime createTime;


    public static final String RPT_DATE = "rpt_date";

    public static final String ACTIVITY_TYPE = "activity_type";

    public static final String GAME_CODE = "game_code";

    public static final String APP_ID = "app_id";

    public static final String UID = "uid";

    public static final String APP_UID = "app_uid";

    public static final String ASSET_TYPE = "asset_type";

    public static final String ASSET_NUM = "asset_num";

    public static final String CREATE_TIME = "create_time";

}
