package com.bxm.game.scene.common.mango.dao.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import com.bxm.game.scene.common.mango.dao.UserPlatformDao;
import com.bxm.game.scene.common.mango.entity.UserPlatform;


/**
 * 各平台用户<br/>
 *
 * @author kerry.jiang
 * @date 2022/5/13 9:45
 */
@ConditionalOnClass(MongoTemplate.class)
public class UserPlatformDaoImpl implements UserPlatformDao {

    @Autowired(required = false)
    private MongoTemplate mongoTemplate;

    @Override
    public UserPlatform save(UserPlatform record) {
        return mongoTemplate.save(record);
    }

    @Override
    public UserPlatform getByPlfuid(String plfuid) {
        Query query = new Query();
        query.addCriteria(Criteria
                .where(UserPlatform.PLFUID).is(plfuid)
        );
        return mongoTemplate.findOne(query, UserPlatform.class);
    }

    @Override
    public UserPlatform getByOnly(Integer platform, String platformId, String uid) {
        Query query = new Query();
        query.addCriteria(Criteria
                .where(UserPlatform.PLATFORM).is(platform)
                .and(UserPlatform.PLATFORM_ID).is(platformId)
                .and(UserPlatform.UID).is(uid)
        );
        return mongoTemplate.findOne(query, UserPlatform.class);
    }
}
