package com.bxm.game.scene.common.mango.dao;


import com.bxm.game.scene.common.mango.entity.UserAssetSub;
import com.bxm.game.scene.common.mango.model.UserAssetSubRequest;

/**
 * 用户子账户<br/>
 *
 * @author kerry.jiang
 * @date 2022/4/12 16:30
 */
public interface UserAssetSubDao {

    /**
     * 保存信息
     * @param record
     */
    UserAssetSub save(UserAssetSub record);

    /**
     * 根据变现猫用户id获取信息
     * @param bxmuid 变现猫用户id
     * @return
     */
    UserAssetSub getByBxmuid(String bxmuid);

    /**
     * 获取app级唯一信息
     * @param request
     * @return
     */
    UserAssetSub getByOnlyApp(UserAssetSubRequest request);

    /**
     * 获取媒介级唯一信息
     * @param request
     * @return
     */
    UserAssetSub getByOnlyMedium(UserAssetSubRequest request);
}
