package com.bxm.game.scene.common.mango.dao;


import com.bxm.game.scene.common.mango.entity.UserPlatform;

/**
 * 各平台用户<br/>
 *
 * @author kerry.jiang
 * @date 2022/4/12 16:30
 */
public interface UserPlatformDao {

    /**
     * 保存信息
     * @param record
     */
    UserPlatform save(UserPlatform record);

    /**
     * 根据全局用户id获取信息
     * @param plfuid 全局用户id
     * @return
     */
    UserPlatform getByPlfuid(String plfuid);

    /**
     * 获取某平台用户信息
     * @param platform 平台类型，1-微信小程序
     * @param platformId 平台ID，如：微信appid
     * @param uid 平台用户id，如：openid
     * @return
     */
    UserPlatform getByOnly(Integer platform, String platformId, String uid);
}
