package com.bxm.game.scene.common.mango.dao.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import com.bxm.game.scene.common.mango.dao.UserAssetSubDao;
import com.bxm.game.scene.common.mango.entity.UserAssetSub;
import com.bxm.game.scene.common.mango.model.UserAssetSubRequest;


/**
 * 用户子账户<br/>
 *
 * @author kerry.jiang
 * @date 2022/4/12 16:30
 */
@ConditionalOnClass(MongoTemplate.class)
public class UserAssetSubDaoImpl implements UserAssetSubDao {

    @Autowired(required = false)
    private MongoTemplate mongoTemplate;

    @Override
    public UserAssetSub save(UserAssetSub record) {
        return mongoTemplate.save(record);
    }

    @Override
    public UserAssetSub getByBxmuid(String bxmuid) {
        Query query = new Query();
        query.addCriteria(Criteria
                .where(UserAssetSub.BXMUID).is(bxmuid)
        );
        return mongoTemplate.findOne(query, UserAssetSub.class);
    }

    @Override
    public UserAssetSub getByOnlyApp(UserAssetSubRequest request) {
        Query query = new Query();
        query.addCriteria(Criteria
                .where(UserAssetSub.PLFUID).is(request.getPlfuid())
                .and(UserAssetSub.ACTIVITY_TYPE).is(request.getActivityType())
                .and(UserAssetSub.GCODE).is(request.getGcode())
                .and(UserAssetSub.MEDIUM).is(request.getMedium())
                .and(UserAssetSub.APPID).is(request.getAppid())
        );
        return mongoTemplate.findOne(query, UserAssetSub.class);
    }

    @Override
    public UserAssetSub getByOnlyMedium(UserAssetSubRequest request) {
        Query query = new Query();
        query.addCriteria(Criteria
                .where(UserAssetSub.ACTIVITY_TYPE).is(request.getActivityType())
                .and(UserAssetSub.GCODE).is(request.getGcode())
                .and(UserAssetSub.MEDIUM).is(request.getMedium())
                .and(UserAssetSub.PLFUID).is(request.getPlfuid())
        );
        return mongoTemplate.findOne(query, UserAssetSub.class);
    }
}
