package com.bxm.game.scene.common.mango.entity;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 各平台用户<br/>
 *
 * @author kerry.jiang
 * @date 2022/4/12 15:56
 */
@Data
@Accessors(chain = true)
@Document(collection = "user_platform")
public class UserPlatform {

    /**
     * 主键（ObjectId，理论上不唯一）
     */
    @Id
    private String id;
    /**
     * 全平台用户id
     * 具有唯一性
     */
    @Field("plfuid")
    private String plfuid;
    /**
     * 平台类型，1-微信小程序
     */
    @Field("platform")
    private Integer platform;
    /**
     * 平台ID，如：微信appid
     */
    @Field("platform_id")
    private String platformId;
    /**
     * 平台用户id，如：openid
     */
    @Field("uid")
    private String uid;
    /**
     * 最近归属bxmuid
     */
    @Field("last_bxmuid")
    private String lastBxmuid;
    /**
     * 手机号
     */
    @Field("phone")
    private String phone;

    public final static String PLFUID = "plfuid";
    public final static String PLATFORM = "platform";
    public final static String PLATFORM_ID = "platform_id";
    public final static String UID = "uid";
    public final static String LAST_BXMUID = "last_bxmuid";
    public final static String PHONE = "phone";
}
