/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.game.scene.common.dal.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.game.scene.common.dal.entity.AssetsLog;
import com.bxm.game.scene.common.dal.mapper.AssetsLogMapper;
import com.bxm.game.scene.common.dal.model.AssetsLogRequest;
import com.bxm.game.scene.common.dal.service.IAssetsLogService;
import com.bxm.warcar.utils.DateHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AssetsLogServiceImpl
extends ServiceImpl<AssetsLogMapper, AssetsLog>
implements IAssetsLogService {
    @Override
    public boolean existTable(String databaseName, String tableName) {
        return ((AssetsLogMapper)this.getBaseMapper()).existTable(databaseName, tableName) > 0;
    }

    @Override
    public void createTableIfNecessary(String databaseName, String tableName) {
        if (!this.existTable(databaseName, tableName)) {
            ((AssetsLogMapper)this.getBaseMapper()).createTable(tableName);
        }
    }

    @Override
    public Page<AssetsLog> pageByUid(String databaseName, Page page, AssetsLogRequest request) {
        if (request.getAppId() == null) {
            return new Page(page.getCurrent(), page.getSize());
        }
        List<String> tableNames = this.filterTableNames(databaseName, this.getMonthDateList(request.getSubmeterDate(), request.getSubmeterMonths()));
        if (CollectionUtils.isEmpty(tableNames)) {
            return new Page(page.getCurrent(), page.getSize());
        }
        return ((AssetsLogMapper)this.getBaseMapper()).pageByUid(page, tableNames, request);
    }

    @Override
    public List<AssetsLog> listByUid(String databaseName, AssetsLogRequest request) {
        if (request.getAppId() == null) {
            return null;
        }
        List<String> tableNames = this.filterTableNames(databaseName, this.getMonthDateList(request.getSubmeterDate(), request.getSubmeterMonths()));
        if (CollectionUtils.isEmpty(tableNames)) {
            return null;
        }
        return ((AssetsLogMapper)this.getBaseMapper()).pageByUid(tableNames, request);
    }

    private List<String> getMonthDateList(Date day, int months) {
        ArrayList<String> list = new ArrayList<String>();
        if (months == 0) {
            return list;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(day);
        cal.set(5, 1);
        list.add(DateHelper.format((Date)cal.getTime(), (String)"yyyyMM"));
        if (months > 0) {
            for (int i = 1; i < months; ++i) {
                ((Calendar)cal).add(2, 1);
                list.add(DateHelper.format((Date)cal.getTime(), (String)"yyyyMM"));
            }
        } else {
            for (int i = -1; i > months; --i) {
                ((Calendar)cal).add(2, -1);
                list.add(DateHelper.format((Date)cal.getTime(), (String)"yyyyMM"));
            }
        }
        return list;
    }

    private List<String> filterTableNames(String databaseName, List<String> ymList) {
        ArrayList<String> list = new ArrayList<String>();
        for (String ym : ymList) {
            String tableName = StringUtils.join((Object[])new String[]{"assets_log_", ym});
            boolean exists = AssetsLog.TABLE_LIST.contains(tableName);
            if (!exists) {
                exists = ((AssetsLogMapper)this.getBaseMapper()).existTable(databaseName, tableName) > 0;
                if (!exists) continue;
                list.add(tableName);
                AssetsLog.TABLE_LIST.add(tableName);
                continue;
            }
            list.add(tableName);
        }
        return list;
    }
}

