package com.bxm.manage.gateway.constant;

import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

/**
 * 网关相关的静态变量定义
 *
 * @author liujia
 */
public class GatewayConstant {
    /**
     * 预发环境的request header键值
     */
    public static final String ENV_HEADER_KEY = "env";

    /**
     * 请求中的用户ID键值
     */
    public static final String USER_ID_KEY = "userId";

    /**
     * 用户的鉴权token
     */
    public static final String USER_TOKEN_KEY = "token";

    /**
     * 需要鉴权的路径标识
     */
    public static final String AUTH_REGULATION_KEY = "security";

    /**
     * 请求鉴权token在header中的名称
     */
    public static final String TOKEN_HEADER = "Authorization";

    public static final String CURRENT_USER_ID = "currentUserId";

    public static final Marker ACCESS = MarkerFactory.getMarker("access");


    private GatewayConstant() {

    }


}