package com.bxm.manage.gateway.filter;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.ResponseJson;
import com.netflix.zuul.ZuulFilter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;

import javax.servlet.http.HttpServletRequest;

@Slf4j
public abstract class AbstractZuulFilter extends ZuulFilter {

    @Override
    public int filterOrder() {
        return FilterOrder.get(getClass());
    }

    @Override
    public boolean shouldFilter() {
        return true;
    }

    /**
     * 获取请求参数的字符串表示(主要用于日志打印)
     *
     * @param request 请求
     * @return 参数字符串
     */
    protected String getReqeustParam(HttpServletRequest request) {
        return WebUtils.getRequestParam(request);
    }

    protected String getRequestBodyContent(HttpServletRequest request) {
        return WebUtils.getRequestBodyContent(request);
    }

    protected String buildResponseJson(HttpStatus code, String errorMsg, Object result) {
        ResponseJson json = ResponseJson.ok()
                .status(code)
                .errorMsg(errorMsg)
                .body(result);
        return JSON.toJSONString(json);
    }
}
