package com.bxm.manage.gateway.filter;

import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;

import static org.springframework.cloud.netflix.zuul.filters.support.FilterConstants.ERROR_TYPE;

/**
 * 日志记录
 *
 * @author gonzo
 * @date 2020-09-03 16:17
 **/
@Slf4j
public class ErrorFilter extends AbstractZuulFilter {

    @Override
    public String filterType() {
        return ERROR_TYPE;
    }

    @Override
    public Object run() throws ZuulException {
        RequestContext requestContext = RequestContext.getCurrentContext();
        Throwable throwable = requestContext.getThrowable();

        HttpServletRequest request = requestContext.getRequest();
        String uri = request.getRequestURI();

        log.error("uri:{} 请求出错", uri, throwable);

        return null;
    }


    @Override
    public int filterOrder() {
        return super.filterOrder();
    }
}
