package com.bxm.manage.gateway.filter;

import com.google.common.collect.Maps;
import com.netflix.zuul.ZuulFilter;

import java.util.Map;

import static org.springframework.cloud.netflix.zuul.filters.support.FilterConstants.DEBUG_FILTER_ORDER;

/**
 * 对zuul过滤器的顺序进行统一定义
 */
class FilterOrder {

    private static Map<Class<? extends ZuulFilter>, Integer> processerOrderMap = Maps.newHashMap();

    private static int order = DEBUG_FILTER_ORDER + 1;

    static {
        // 前置 - 鉴权过滤器，判断是否带有token
        processerOrderMap.put(AuthenticationPreFilter.class, order++);
        // 前置 - 请求内容重构过滤器
        processerOrderMap.put(RefactorFilter.class, order++);

        // error 排序无所谓
        processerOrderMap.put(ErrorFilter.class, order++);
    }

    static int get(Class<? extends ZuulFilter> clasz) {
        return processerOrderMap.get(clasz);
    }
}
