package com.bxm.manage.gateway.properties;

import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Map;

/**
 * 业务配置信息
 *
 * @author liujia
 */
@ConfigurationProperties(prefix = "manage.gateway")
@Data
public class GatewayProperties {


    /**
     * 允许访问系统的请求来源
     */
    private String allowedOrigins = "*";

    /**
     * 允许请求来源
     */
    private String allowOrigins = "*";

    /**
     * 不进行鉴权的路径，默认运营后台所有请求都需要鉴权才可以访问
     */
    private Map<String, String> skipAuthUrl = Maps.newHashMap();

    /**
     * token加密密钥
     */
    private String tokenSecret = "";

    /**
     * 是否开启鉴权
     */
    private boolean enableAuth = true;
}
