package com.bxm.huola.message.common.bo;

import com.bxm.huola.message.common.constant.PushFoldTypeEnum;
import com.bxm.huola.message.common.constant.PushSoundEnum;
import com.bxm.huola.message.common.constant.TemplateTypeEnum;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.BaseBean;

/**
 * 消息推送构建参数
 *
 * @author liujia 2018/8/15 11:26
 */
public class PushMessage extends BaseBean {

    /**
     * 显示在通知栏的标题
     */
    private String title;

    /**
     * 显示内容
     */
    private String content;

    /**
     * 是否静音（收到消息不提示声音）
     */
    private boolean mute = false;

    /**
     * 接收到消息时的提示音（如果mute设置为true则此设置无效）
     */
    private PushSoundEnum sound = PushSoundEnum.DEFAULT_SOUND;

    /**
     * 推送消息类型(默认为通知)
     */
    private TemplateTypeEnum type = TemplateTypeEnum.NOTIFCTION;

    /**
     * 额外的承载信息
     * 根据具体的业务消息类型增加对应的参数
     */
    private PushPayloadInfo payloadInfo = PushPayloadInfo.build();

    /**
     * 是否持久化消息（是否将推送的消息同时写入到对应用户的个人消息中）
     */
    private boolean persistence = true;

    /**
     * 接收推送消息的用户范围定义
     */
    private PushReceiveScope pushReceiveScope;

    /**
     * 是否浮动通知
     */
    private boolean floatNotify;

    /**
     * 展开通知方式
     */
    private PushFoldTypeEnum pushFoldType;

    /**
     * 展开式通知图片路径
     */
    private String notifyImageUrl;

    /**
     * 展开式通知文本
     */
    private String notifyText;

    /**
     * 消息有效期（单位：小时）
     * 默认24小时
     */
    private Integer periodTime = 24;

    /**
     * 是否震动
     */
    private boolean isShock;

    /**
     * 是否纳入统计，用户推送的消息一般不进行统计，主要是运营后台
     * 纳入统计的消息将进行持久化，记录到单独的统计库中，用于后台的检索、查询与管理
     */
    private boolean statistics = false;

    /**
     * 是否强制送达，默认不允许
     * 强制送达的消息会跳过一些验证规则
     * 包括：
     * 时间段限制（防止打扰用户）
     */
    private boolean force = false;

    /**
     * 推送后的动作
     */
    private Byte actionType = 1;

    private String srcApp;

    private PushMessage(String title, String content) {
        this.title = title;
        this.content = content;
    }

    private PushMessage() {

    }

    public static PushMessage build() {
        return new PushMessage();
    }

    public static PushMessage build(String title, String content) {
        PushMessage message = new PushMessage();
        message.title = title;
        message.content = content;
        return message;
    }

    public PushReceiveScope getPushReceiveScope() {
        return pushReceiveScope;
    }

    /**
     * 设置消息的接收范围
     *
     * @param pushReceiveScope 消息接收范围
     * @return 推送消息对象
     */
    public PushMessage setPushReceiveScope(PushReceiveScope pushReceiveScope) {
        this.pushReceiveScope = pushReceiveScope;
        return this;
    }

    /**
     * 指定消息的接收人
     *
     * @param userId 推送消息的接收人
     * @return 当前推送消息
     */
    public PushMessage assign(Long userId) {
        this.pushReceiveScope = PushReceiveScope.pushSignle(userId);
        return this;
    }

    public boolean isShock() {
        return isShock;
    }

    public void setShock(boolean shock) {
        isShock = shock;
    }

    public Integer getPeriodTime() {
        return periodTime;
    }

    public void setPeriodTime(Integer periodTime) {
        this.periodTime = periodTime;
    }

    public boolean isFloatNotify() {
        return floatNotify;
    }

    public void setFloatNotify(boolean floatNotify) {
        this.floatNotify = floatNotify;
    }

    public PushFoldTypeEnum getPushFoldType() {
        return pushFoldType;
    }

    public void setPushFoldType(PushFoldTypeEnum pushFoldType) {
        this.pushFoldType = pushFoldType;
    }

    public String getNotifyImageUrl() {
        return notifyImageUrl;
    }

    public void setNotifyImageUrl(String notifyImageUrl) {
        this.notifyImageUrl = notifyImageUrl;
    }

    public String getNotifyText() {
        return notifyText;
    }

    public void setNotifyText(String notifyText) {
        this.notifyText = notifyText;
    }

    public boolean isPersistence() {
        return persistence;
    }

    public PushMessage setPersistence(boolean persistence) {
        this.persistence = persistence;
        return this;
    }

    public PushSoundEnum getSound() {
        return this.sound;
    }

    public PushMessage setSound(PushSoundEnum sound) {
        this.sound = sound;
        return this;
    }

    public boolean isMute() {
        return this.mute;
    }

    public PushMessage setMute(boolean mute) {
        this.mute = mute;
        return this;
    }

    public TemplateTypeEnum getType() {
        return this.type;
    }

    public PushMessage setType(TemplateTypeEnum type) {
        this.type = type;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public PushMessage setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public PushMessage setContent(String content) {
        this.content = content;
        return this;
    }

    public Long getMsgId() {
        return getPayloadInfo().getMsgId();
    }

    public String getSrcApp() {
        return srcApp;
    }

    public PushMessage setSrcApp(String srcApp) {
        this.srcApp = srcApp;
        return this;
    }

    public PushPayloadInfo getPayloadInfo() {
        if (null == this.payloadInfo) {
            this.payloadInfo = PushPayloadInfo.build();
        }

        //同步消息信息到消息发送主体
        if (StringUtils.isBlank(payloadInfo.getTitle())) {
            payloadInfo.setTitle(getTitle());
        }
        if (StringUtils.isBlank(payloadInfo.getContent())) {
            payloadInfo.setContent(getContent());
        }
        if (null != getSound()) {
            payloadInfo.setSound(getSound().getAndriodSound());
        }
        return this.payloadInfo;
    }

    public PushMessage setPayloadInfo(PushPayloadInfo payloadInfo) {
        if (null == payloadInfo) {
            this.payloadInfo = PushPayloadInfo.build();
        } else {
            this.payloadInfo = payloadInfo;
        }
        return this;
    }

    public Byte getActionType() {
        return actionType;
    }

    public PushMessage setActionType(Byte actionType) {
        this.actionType = actionType;
        return this;
    }

    public boolean isStatistics() {
        return statistics;
    }

    public PushMessage setStatistics(boolean statistics) {
        this.statistics = statistics;
        return this;
    }

    public boolean isForce() {
        return force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    /**
     * 验证当前消息是否正确
     *
     * @return true表示消息格式正确
     */
    public boolean valid() {
        return pushReceiveScope != null && payloadInfo != null;
    }
}
