package com.bxm.huola.message.common.bo;

import com.bxm.newidea.component.JSONObject;
import com.bxm.newidea.component.vo.BaseBean;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.math.NumberUtils;

import java.util.Map;

/**
 * 消息负荷对象，用于存放推送、用户事件中对消息的具体定义
 *
 * @author liujia
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "消息主体内容")
@Data
@Accessors(chain = true)
public class PushPayloadInfo extends BaseBean {

    @ApiModelProperty("当前推送消息的ID")
    private Long msgId;

    @ApiModelProperty("创建消息的时间(时间戳)")
    private Long createTime;

    @ApiModelProperty("消息标题")
    private String title;

    @ApiModelProperty("消息内容")
    private String content;

    @ApiModelProperty("通知使用的铃声")
    private String sound;

    /**
     * 跳转协议，历史版本中从extend中获取url参数
     * 新版本使用此字段进行统一的协议地址跳转，不再需要判断type中的值
     * 如果指定了协议，强制设定类型为10，这里是为了兼容历史逻辑
     */
    @ApiModelProperty("跳转协议 以前是把url放在 extend中，往后可以直接放到这个字段，客户端拿到直接跳转")
    private String protocol;

    @ApiModelProperty("业务类型，不同的项目对业务类型的定义不同")
    private String bizType;

    @ApiModelProperty("额外参数，根据当前的推送类型会有不同的返回值")
    private Map<String, Object> extend = Maps.newHashMap();

    public static PushPayloadInfo build() {
        return new PushPayloadInfo().setCreateTime(System.currentTimeMillis());
    }

    public Long getTargetUserId() {
        Object userIdObj = getExtend().get("userId");
        if (null == userIdObj) {
            return null;
        }
        if (userIdObj instanceof Long) {
            return Long.valueOf(userIdObj.toString());
        }

        return NumberUtils.toLong(userIdObj.toString());
    }

    public PushPayloadInfo addTargetUserId(Long userId) {
        addExtend("userId", userId);
        return this;
    }

    public PushPayloadInfo addExtend(String key, Object value) {
        if (this.extend == null) {
            this.extend = Maps.newHashMap();
        }

        this.extend.put(key, value);
        return this;
    }

    public Long getMsgId() {
        return msgId;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public String toJsonString() {
        return JSONObject.toJSONString(this);
    }

    public Map<String, Object> getExtend() {
        return this.extend;
    }

    public void setExtend(Map<String, Object> extend) {
        this.extend = extend;
    }
}
