/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.huola.message.common.bo;

import com.bxm.huola.message.common.bo.PushMessageSender;
import com.bxm.huola.message.common.bo.PushPayloadInfo;
import com.bxm.huola.message.common.bo.PushReceiveScope;
import com.bxm.huola.message.common.constant.PushFoldTypeEnum;
import com.bxm.huola.message.common.constant.PushSoundEnum;
import com.bxm.huola.message.common.constant.TemplateTypeEnum;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.BaseBean;

public class PushMessage
extends BaseBean {
    private String title;
    private String content;
    private boolean mute = false;
    private PushSoundEnum sound = PushSoundEnum.DEFAULT_SOUND;
    private TemplateTypeEnum type = TemplateTypeEnum.NOTIFCTION;
    private PushPayloadInfo payloadInfo = PushPayloadInfo.build();
    private boolean persistence = true;
    private PushReceiveScope pushReceiveScope;
    private boolean floatNotify;
    private PushFoldTypeEnum pushFoldType;
    private String notifyImageUrl;
    private String notifyText;
    private Integer periodTime = 24;
    private boolean isShock;
    private boolean statistics = false;
    private boolean force = false;
    private String srcApp;
    private PushMessageSender sender;

    private PushMessage(String title, String content) {
        this.title = title;
        this.content = content;
    }

    private PushMessage() {
    }

    public static PushMessage build() {
        return new PushMessage();
    }

    public static PushMessage build(String title, String content) {
        PushMessage message = new PushMessage();
        message.title = title;
        message.content = content;
        return message;
    }

    public static PushMessage build(String title, String content, String srcApp, Long targetUserId) {
        PushMessage message = PushMessage.build(title, content);
        message.assign(targetUserId);
        message.setSrcApp(srcApp);
        return message;
    }

    public static PushMessage build(String title, String content, String srcApp, String protocol, Long targetUserId) {
        PushMessage message = PushMessage.build(title, content);
        message.assign(targetUserId);
        message.setSrcApp(srcApp);
        message.getPayloadInfo().setProtocol(protocol);
        return message;
    }

    public PushReceiveScope getPushReceiveScope() {
        return this.pushReceiveScope;
    }

    public PushMessage setPushReceiveScope(PushReceiveScope pushReceiveScope) {
        this.pushReceiveScope = pushReceiveScope;
        return this;
    }

    public PushMessage assign(Long userId) {
        this.pushReceiveScope = PushReceiveScope.pushSignle(userId);
        return this;
    }

    public boolean isShock() {
        return this.isShock;
    }

    public void setShock(boolean shock) {
        this.isShock = shock;
    }

    public Integer getPeriodTime() {
        return this.periodTime;
    }

    public void setPeriodTime(Integer periodTime) {
        this.periodTime = periodTime;
    }

    public boolean isFloatNotify() {
        return this.floatNotify;
    }

    public void setFloatNotify(boolean floatNotify) {
        this.floatNotify = floatNotify;
    }

    public PushFoldTypeEnum getPushFoldType() {
        return this.pushFoldType;
    }

    public void setPushFoldType(PushFoldTypeEnum pushFoldType) {
        this.pushFoldType = pushFoldType;
    }

    public String getNotifyImageUrl() {
        return this.notifyImageUrl;
    }

    public void setNotifyImageUrl(String notifyImageUrl) {
        this.notifyImageUrl = notifyImageUrl;
    }

    public String getNotifyText() {
        return this.notifyText;
    }

    public void setNotifyText(String notifyText) {
        this.notifyText = notifyText;
    }

    public boolean isPersistence() {
        return this.persistence;
    }

    public PushMessage setPersistence(boolean persistence) {
        this.persistence = persistence;
        return this;
    }

    public PushSoundEnum getSound() {
        return this.sound;
    }

    public PushMessage setSound(PushSoundEnum sound) {
        this.sound = sound;
        return this;
    }

    public boolean isMute() {
        return this.mute;
    }

    public PushMessage setMute(boolean mute) {
        this.mute = mute;
        return this;
    }

    public TemplateTypeEnum getType() {
        return this.type;
    }

    public PushMessage setType(TemplateTypeEnum type) {
        this.type = type;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public PushMessage setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public PushMessage setContent(String content) {
        this.content = content;
        return this;
    }

    public Long getMsgId() {
        return this.getPayloadInfo().getMsgId();
    }

    public String getSrcApp() {
        return this.srcApp;
    }

    public PushMessage setSrcApp(String srcApp) {
        this.srcApp = srcApp;
        return this;
    }

    public PushMessageSender getSender() {
        return this.sender;
    }

    public PushMessage setSender(PushMessageSender sender) {
        this.sender = sender;
        return this;
    }

    public PushPayloadInfo getPayloadInfo() {
        if (null == this.payloadInfo) {
            this.payloadInfo = PushPayloadInfo.build();
        }
        if (StringUtils.isBlank((CharSequence)this.payloadInfo.getTitle())) {
            this.payloadInfo.setTitle(this.getTitle());
        }
        if (StringUtils.isBlank((CharSequence)this.payloadInfo.getContent())) {
            this.payloadInfo.setContent(this.getContent());
        }
        if (null != this.getSound()) {
            this.payloadInfo.setSound(this.getSound().getAndriodSound());
        }
        return this.payloadInfo;
    }

    public PushMessage setPayloadInfo(PushPayloadInfo payloadInfo) {
        this.payloadInfo = null == payloadInfo ? PushPayloadInfo.build() : payloadInfo;
        return this;
    }

    public boolean isStatistics() {
        return this.statistics;
    }

    public PushMessage setStatistics(boolean statistics) {
        this.statistics = statistics;
        return this;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean valid() {
        return this.pushReceiveScope != null && this.payloadInfo != null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PushMessage)) {
            return false;
        }
        PushMessage other = (PushMessage)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isMute() != other.isMute()) {
            return false;
        }
        if (this.isPersistence() != other.isPersistence()) {
            return false;
        }
        if (this.isFloatNotify() != other.isFloatNotify()) {
            return false;
        }
        if (this.isShock() != other.isShock()) {
            return false;
        }
        if (this.isStatistics() != other.isStatistics()) {
            return false;
        }
        if (this.isForce() != other.isForce()) {
            return false;
        }
        Integer this$periodTime = this.getPeriodTime();
        Integer other$periodTime = other.getPeriodTime();
        if (this$periodTime == null ? other$periodTime != null : !((Object)this$periodTime).equals(other$periodTime)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        PushSoundEnum this$sound = this.getSound();
        PushSoundEnum other$sound = other.getSound();
        if (this$sound == null ? other$sound != null : !((Object)((Object)this$sound)).equals((Object)other$sound)) {
            return false;
        }
        TemplateTypeEnum this$type = this.getType();
        TemplateTypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        PushPayloadInfo this$payloadInfo = this.getPayloadInfo();
        PushPayloadInfo other$payloadInfo = other.getPayloadInfo();
        if (this$payloadInfo == null ? other$payloadInfo != null : !((Object)((Object)this$payloadInfo)).equals((Object)other$payloadInfo)) {
            return false;
        }
        PushReceiveScope this$pushReceiveScope = this.getPushReceiveScope();
        PushReceiveScope other$pushReceiveScope = other.getPushReceiveScope();
        if (this$pushReceiveScope == null ? other$pushReceiveScope != null : !((Object)((Object)this$pushReceiveScope)).equals((Object)other$pushReceiveScope)) {
            return false;
        }
        PushFoldTypeEnum this$pushFoldType = this.getPushFoldType();
        PushFoldTypeEnum other$pushFoldType = other.getPushFoldType();
        if (this$pushFoldType == null ? other$pushFoldType != null : !((Object)((Object)this$pushFoldType)).equals((Object)other$pushFoldType)) {
            return false;
        }
        String this$notifyImageUrl = this.getNotifyImageUrl();
        String other$notifyImageUrl = other.getNotifyImageUrl();
        if (this$notifyImageUrl == null ? other$notifyImageUrl != null : !this$notifyImageUrl.equals(other$notifyImageUrl)) {
            return false;
        }
        String this$notifyText = this.getNotifyText();
        String other$notifyText = other.getNotifyText();
        if (this$notifyText == null ? other$notifyText != null : !this$notifyText.equals(other$notifyText)) {
            return false;
        }
        String this$srcApp = this.getSrcApp();
        String other$srcApp = other.getSrcApp();
        if (this$srcApp == null ? other$srcApp != null : !this$srcApp.equals(other$srcApp)) {
            return false;
        }
        PushMessageSender this$sender = this.getSender();
        PushMessageSender other$sender = other.getSender();
        return !(this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PushMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isMute() ? 79 : 97);
        result = result * 59 + (this.isPersistence() ? 79 : 97);
        result = result * 59 + (this.isFloatNotify() ? 79 : 97);
        result = result * 59 + (this.isShock() ? 79 : 97);
        result = result * 59 + (this.isStatistics() ? 79 : 97);
        result = result * 59 + (this.isForce() ? 79 : 97);
        Integer $periodTime = this.getPeriodTime();
        result = result * 59 + ($periodTime == null ? 43 : ((Object)$periodTime).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        PushSoundEnum $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : ((Object)((Object)$sound)).hashCode());
        TemplateTypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        PushPayloadInfo $payloadInfo = this.getPayloadInfo();
        result = result * 59 + ($payloadInfo == null ? 43 : ((Object)((Object)$payloadInfo)).hashCode());
        PushReceiveScope $pushReceiveScope = this.getPushReceiveScope();
        result = result * 59 + ($pushReceiveScope == null ? 43 : ((Object)((Object)$pushReceiveScope)).hashCode());
        PushFoldTypeEnum $pushFoldType = this.getPushFoldType();
        result = result * 59 + ($pushFoldType == null ? 43 : ((Object)((Object)$pushFoldType)).hashCode());
        String $notifyImageUrl = this.getNotifyImageUrl();
        result = result * 59 + ($notifyImageUrl == null ? 43 : $notifyImageUrl.hashCode());
        String $notifyText = this.getNotifyText();
        result = result * 59 + ($notifyText == null ? 43 : $notifyText.hashCode());
        String $srcApp = this.getSrcApp();
        result = result * 59 + ($srcApp == null ? 43 : $srcApp.hashCode());
        PushMessageSender $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        return result;
    }
}

