/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.huola.message.common.constant;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public enum MessageTypeEnum {
    INTERACTION,
    SYSTEM("\u7cfb\u7edf\u901a\u77e5", "https://m.wstong.com/localnews_prod/message/system.png"),
    SHARE,
    COMMENT("\u8bc4\u8bba\u901a\u77e5", "https://m.wstong.com/localnews_prod/message/comment.png"),
    LIKE("\u70b9\u8d5e\u901a\u77e5", "https://m.wstong.com/localnews_prod/message/like.png"),
    INVITE,
    BALANCE("\u4f59\u989d\u53d8\u52a8", "https://m.wstong.com/localnews_prod/message/balance.png"),
    NEWS("\u4eca\u65e5\u70ed\u95fb", "https://m.wstong.com/localnews_prod/message/news.png"),
    ADD_FUNS("\u65b0\u589e\u7c89\u4e1d", "https://m.wstong.com/localnews_prod/material/icon_new_flower.png"),
    LIKE_AND_COMMENT("\u8bc4\u8bba\u70b9\u8d5e", "https://m.wstong.com/localnews_prod/material/icon_comment.png"),
    AT_ME("@\u6211\u7684", "https://m.wstong.com/localnews_prod/material/icon_remind.png");

    private String title;
    private String icon;

    private MessageTypeEnum() {
    }

    private MessageTypeEnum(String title, String icon) {
        this.title = title;
        this.icon = icon;
    }

    public String getTitle() {
        return this.title;
    }

    public String getIcon() {
        return this.icon;
    }

    public static List<MessageTypeEnum> getMessageCenterListType() {
        ArrayList typeList = Lists.newArrayList();
        typeList.add(SYSTEM);
        typeList.add(NEWS);
        typeList.add(BALANCE);
        return typeList;
    }

    public static List<MessageTypeEnum> getTopType() {
        ArrayList typeList = Lists.newArrayList();
        typeList.add(LIKE_AND_COMMENT);
        typeList.add(ADD_FUNS);
        typeList.add(AT_ME);
        return typeList;
    }

    public static boolean isInteraction(String msgType) {
        return COMMENT.name().equals(msgType) || LIKE.name().equals(msgType) || INVITE.name().equals(msgType) || SHARE.name().equals(msgType) || AT_ME.name().equals(msgType);
    }

    public static Set<MessageTypeEnum> getInteractionType() {
        return ImmutableSet.of((Object)((Object)COMMENT), (Object)((Object)LIKE), (Object)((Object)INVITE), (Object)((Object)SHARE));
    }
}

