package com.bxm.thirdparty.grant.facade.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

@ApiModel(description = "小程序主动授权信息")
@Data
@ToString
public class MiniAppAuthParam implements Serializable {

    @ApiModelProperty("登录时返回的密钥")
    private String sessionKey;

    @ApiModelProperty("当前小程序的APPID")
    private String appId;

    @ApiModelProperty("用户同意授权后的签名数据")
    private String signature;

    @ApiModelProperty("用户同意授权后的原始数据")
    private String rawData;

    @ApiModelProperty("用户同意授权后的加密数据")
    private String encryptedData;

    @ApiModelProperty("用户同意授权后的初始向量")
    private String iv;
}
