package com.bxm.thirdparty.grant.facade.param;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 微信推送的模板消息
 *
 * @author liujia
 * @date 2023/04/18 16:28:06
 * @since 1.0.0
 */
@Data
public class WechatMpTemplateMessage implements Serializable {
    /**
     * 公众号Appid
     */
    private String wechatMpAppId;

    /**
     * 接受消息的用户的openId
     */
    private String toUserOpenId;

    /**
     * 模板id
     */
    private String templateId;

    /**
     * 跳转的地址,和小程序跳转二选一
     */
    private String jumpUrl;

    /**
     * 小程序跳转信息，如果跳转失败，则会跳转到jumpUrl
     */
    private WechatMpJumpMiniApp jumpMiniApp;

    private List<WechatMpTemplateData> templateDataList;

    public WechatMpTemplateMessage addJumpMiniApp(String appId, String path) {
        WechatMpJumpMiniApp miniApp = new WechatMpJumpMiniApp();
        miniApp.setAppId(appId);
        miniApp.setPath(path);
        
        this.jumpMiniApp = miniApp;
        return this;
    }

    public WechatMpTemplateMessage addTemplateData(String name, String value) {
        return addTemplateData(name, value, null);
    }

    public WechatMpTemplateMessage addTemplateData(String name, String value, String color) {
        if (null == templateDataList) {
            templateDataList = new ArrayList<>();
        }
        WechatMpTemplateData templateData = new WechatMpTemplateData();
        templateData.setColor(color);
        templateData.setName(name);
        templateData.setValue(value);
        templateDataList.add(templateData);
        return this;
    }
}
