package com.bxm.thirdparty.payment.bo;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 下单的前置检查结果
 *
 * @author liujia
 * @date 9/15/21 6:33 PM
 **/
@Data
public class PreCheckResultBO {

    /**
     * 是否重复下单
     */
    private Boolean repeat = false;

    /**
     * 如果可以正常下单，订单的显示标题，可能是商品名称或其他自定义名称
     */
    private String title;

    /**
     * 订单描述，用户支付时可以查看
     */
    private String description;

    /**
     * 支付金额，如果为空，则采用请求参数中设定的金额
     */
    private BigDecimal amount;

    /**
     * 是否为模拟订单，模拟订单不需要走真实的支付流程，直接支付成功
     * 开发自测时，进行订单模拟，连支付动作都不需要有
     */
    private Boolean mockOrder;

    /**
     * 使用模拟金额
     * 为了测试能完整的走完支付流程，但是不需要足额的进行支付
     */
    private Boolean mockAmount;
}
