package com.bxm.thirdparty.payment.param;

import com.bxm.thirdparty.payment.enums.WithdrawTypeEnum;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 提现申请参数
 *
 * @author liujia
 * @date 7/6/21 7:32 PM
 **/
@Data
@Builder
public class WithdrawRequest implements Serializable {

    @Tolerate
    public WithdrawRequest() {
    }

    /**
     * 申请提现类型
     */
    private WithdrawTypeEnum type;

    /**
     * 申请提现的应用中的流水ID
     * 应用方存储的提现申请流水
     */
    private Long thirdFlowId;

    /**
     * 提现业务对应的应用
     * 必传参数
     */
    private String srcApp;

    /**
     * 业务场景，适用于一个应用有多种支付场景的情况
     * 可选参数
     */
    private String scene;

    /**
     * 收款的用户，对应的申请提现类型必须有授权信息
     */
    private Long userId;

    /**
     * 提现金额
     */
    private BigDecimal amount;

    /**
     * 提现备注信息
     */
    private String remark;

    /**
     * 提现显示的标题
     */
    private String title;

    /**
     * 请求来源IP
     */
    private String requestIp;

    public boolean check() {
        return null != srcApp && amount != null && thirdFlowId != null && type != null;
    }
}
