package com.bxm.thirdparty.payment.callback;

import com.bxm.thirdparty.payment.bo.PreCheckResultBO;
import com.bxm.thirdparty.payment.config.PaymentExposeController;

/**
 * 引入当前模块的其他服务负责实现
 * <p>
 * 通过{@link PaymentExposeController}对外暴露
 * 支付服务通过调用rest api进行回调。增加了接口，需要同步增加暴露的API
 *
 * @author liujia
 * @date 9/12/21 3:54 PM
 **/
public interface PaymentCallbackService {

    /**
     * 检查订单对应的业务是否重复下单
     *
     * @param bizId 业务ID
     * @return 是否重复下单
     */
    PreCheckResultBO checkRepeat(String bizId);

    /**
     * 业务对应的支付订单支付成功
     *
     * @param bizId 业务ID
     */
    void paymentSuccess(String bizId);

    /**
     * 业务对应的支付订单支付失败
     *
     * @param bizId        业务ID
     * @param errorMessage 失败原因
     */
    void paymentFail(String bizId, String errorMessage);

    /**
     * 当前支付生命周期服务对应的订单类型
     *
     * @return 订单类型orderType
     */
    String support();
}
