package com.bxm.thirdparty.payment.enums;

/**
 * 订单状态枚举
 *
 * @author liujia
 * @date 7/7/21 3:44 PM
 **/
public enum OrderStatusEnum {

    /**
     * 等待处理
     */
    WAITING(0),

    /**
     * 调用成功
     */
    SUCCEED(1),

    /**
     * 调用失败
     */
    FAILED(2),

    ;

    private int code;

    OrderStatusEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }

    public static OrderStatusEnum get(int code) {
        for (OrderStatusEnum statusEnum : OrderStatusEnum.values()) {
            if (statusEnum.getCode() == code) {
                return statusEnum;
            }
        }

        return null;
    }

    public boolean equalsCode(int code) {
        return this.getCode() == code;
    }
}
