package com.bxm.thirdparty.payment.config;

import com.bxm.newidea.component.controller.BaseController;
import com.bxm.thirdparty.payment.bo.PreCheckResultBO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 引入当前模块后，暴露一些接口，供支付服务进行回调
 * 为了防止发生相互依赖，这里使用rest api暴露接口
 *
 * @author liujia
 * @date 9/12/21 4:29 PM
 **/
@RestController
@RequestMapping("expose/payment")
@Slf4j
public class PaymentExposeController extends BaseController {

    @Resource
    private PaymentCallbackRegister paymentCallbackRegister;

    @GetMapping("checkRepeat")
    public PreCheckResultBO checkRepeat(String orderType, String bizId) {
        return paymentCallbackRegister.loadInstance(orderType).checkRepeat(bizId);
    }

    @GetMapping("paymentSuccess")
    public void paymentSuccess(String orderType, String bizId) {
        paymentCallbackRegister.loadInstance(orderType).paymentSuccess(bizId);
    }

    @GetMapping("paymentFail")
    public void paymentFail(String orderType, String bizId, String errorMessage) {
        paymentCallbackRegister.loadInstance(orderType).paymentFail(bizId, errorMessage);
    }

    @GetMapping("refundSuccess")
    public void refundSuccess(String orderType, String bizId, BigDecimal refundAmount, Date refundTime) {
        paymentCallbackRegister.loadInstance(orderType).refundSuccess(bizId, refundAmount, refundTime);
    }

    @GetMapping("refundFail")
    public void refundFail(String orderType, String bizId, String errorMessage) {
        paymentCallbackRegister.loadInstance(orderType).refundFail(bizId, errorMessage);
    }
}
