package com.bxm.thirdparty.payment.facade;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.bo.RefundOrderResultBO;
import com.bxm.thirdparty.payment.callback.PaymentCallbackService;
import com.bxm.thirdparty.payment.param.BindAccountRelation;

import java.math.BigDecimal;
import java.util.List;

/**
 * 支付服务的对外接口
 *
 * @author liujia
 * @date 6/18/21 3:53 PM
 **/
public interface PaymentFacadeService {

    /**
     * 执行支付订单退款操作
     *
     * @param bizId  业务ID
     * @param srcApp 所属业务
     * @param reason 退款原因
     * @return 退款提交结果，不代表真实退款
     */
    @Deprecated
    Message applyPaymentRefund(Long bizId, String srcApp, String reason);

    /**
     * 申请退款
     *
     * @param bizId  商业标识
     * @param srcApp src应用
     * @param reason 原因
     * @return {@link RefundOrderResultBO} 根据refundSuccess来决定退款是否直接成功
     *
     */
    RefundOrderResultBO applyRefund(Long bizId, String srcApp, String reason);

    /**
     * 执行支付订单退款操作，并仅退部分金额
     *
     * @param bizId        业务ID
     * @param srcApp       所属业务
     * @param refundAmount 退款金额
     * @param reason       退款原因
     * @return 退款提交结果，不代表真实退款
     */
    Message applyPaymentRefund(Long bizId, String srcApp, BigDecimal refundAmount, String reason);

    /**
     * 注册订单类型到支付服务，实现了{@link PaymentCallbackService#bindRelation()}会自动调用
     *
     * @param orderType            订单类型
     * @param bindAccountRelations 业务场景绑定
     * @return {@link Message}
     */
    Message register(String orderType, List<BindAccountRelation> bindAccountRelations);
}
