package com.bxm.thirdparty.payment.mock;

import com.bxm.newidea.component.bo.Message;
import com.bxm.thirdparty.payment.bo.RefundOrderResultBO;
import com.bxm.thirdparty.payment.facade.PaymentFacadeService;
import com.bxm.thirdparty.payment.param.BindAccountRelation;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author liujia
 * @date 10/9/21 12:20 PM
 **/
@Slf4j
public class PaymentFacadeServiceMock implements PaymentFacadeService {

    @Override
    @Deprecated
    public Message applyPaymentRefund(Long bizId, String srcApp, String reason) {
        log.error("调用支付服务失败，请求参数：{} - {} - {}", bizId, srcApp, reason);
        return Message.build(false, "调用支付服务失败");
    }

    @Override
    public Message applyPaymentRefund(Long bizId, String srcApp, BigDecimal refundAmount, String reason) {
        log.error("调用支付服务失败，请求参数：{} - {} - {} - {}", bizId, srcApp, refundAmount, reason);
        return Message.build(false, "调用支付服务失败");
    }

    @Override
    public Message register(String orderType, List<BindAccountRelation> bindAccountRelations) {
        log.error("调用支付服务失败，请求参数：{} - {}", orderType, bindAccountRelations);
        return Message.build(false, "注册订单支付失败");
    }

    @Override
    public RefundOrderResultBO applyRefund(Long bizId, String srcApp, String reason) {
        log.error("调用支付服务失败，请求参数：{} - {} - {}", bizId, srcApp, reason);
        return RefundOrderResultBO.builder()
                .requestSuccess(Boolean.FALSE)
                .errorMsg("调用支付服务失败")
                .build();
    }
}
