package com.bxm.thirdparty.payment.param;

import com.bxm.thirdparty.payment.enums.PaymentSceneEnum;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;

/**
 * 当前支付类型绑定的账号和场景
 *
 * @author liujia
 * @date 2022/07/01 10:10:04
 * @since 1.0.0
 */
@Data
@Builder
public class BindAccountRelation implements Serializable {
    @Tolerate
    public BindAccountRelation() {
    }

    /**
     * 使用的账号ID
     */
    private Long accountId;

    /**
     * 支付场景
     */
    private PaymentSceneEnum scene;

    /**
     * 服务名称 - 对应nacos中的服务名称
     */
    private String serviceName;

    /**
     * 来源应用
     */
    private String srcApp;
}
