/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.thirdparty.payment.config;

import cn.hutool.core.collection.CollectionUtil;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.thirdparty.payment.callback.PaymentCallbackService;
import com.bxm.thirdparty.payment.facade.PaymentFacadeService;
import com.bxm.thirdparty.payment.param.BindAccountRelation;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class PaymentCallbackRegister
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(PaymentCallbackRegister.class);
    private static final Map<String, PaymentCallbackService> INSTANCE_MAP = Maps.newHashMap();
    @Value(value="${spring.application.name}")
    private String applicationName;

    public PaymentCallbackService loadInstance(String orderType) {
        PaymentCallbackService paymentCallbackService = INSTANCE_MAP.get(orderType);
        if (null == paymentCallbackService) {
            log.error("\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u914d\u7f6e\u3010payment.config.paymentTypeMap.{}\u3011\u5bf9\u5e94\u7684\u670d\u52a1", (Object)orderType);
            throw new IllegalArgumentException("\u672a\u914d\u7f6e[" + orderType + "]\u5bf9\u5e94\u7684PaymentPhaseService");
        }
        return paymentCallbackService;
    }

    public void run(ApplicationArguments args) {
        Collection phaseServices = SpringContextHolder.getBeans(PaymentCallbackService.class);
        HashSet orderTypeSet = Sets.newHashSet();
        for (PaymentCallbackService phaseService : phaseServices) {
            log.info("\u6ce8\u518c\u8ba2\u5355\u7c7b\u578b[{}]\u5bf9\u5e94\u7684\u903b\u8f91\u5904\u7406", (Object)phaseService.support());
            if (!orderTypeSet.add(phaseService.support())) {
                throw new IllegalArgumentException("[{}]\u5b9a\u4e49\u91cd\u590d\uff0c\u4e00\u4e2a\u8ba2\u5355\u7c7b\u578b\u53ea\u80fd\u5b9a\u4e49\u4e00\u4e2a\u56de\u8c03\u7c7b");
            }
            INSTANCE_MAP.put(phaseService.support(), phaseService);
        }
        log.info("\u8ba2\u5355\u7c7b\u578b\u548c\u56de\u8c03\u7ed1\u5b9a\u5904\u7406\u5b8c\u6210");
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(() -> {
            log.info("\u5f00\u59cb\u6267\u884c\u7ed1\u5b9a\u670d\u52a1\u6ce8\u518c");
            try {
                this.createLazyRegisterTask();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            log.info("\u6267\u884c\u7ed1\u5b9a\u670d\u52a1\u6ce8\u518c\u5b8c\u6210");
        });
    }

    private void createLazyRegisterTask() {
        int retryTime = 5;
        while (true) {
            if (retryTime <= 0) {
                log.error("\u91cd\u8bd55\u6b21\u540e\uff0c\u4ecd\u7136\u6ce8\u518c\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e\u6216\u8005\u652f\u4ed8\u670d\u52a1\u5728\u7ebf");
                break;
            }
            try {
                TimeUnit.SECONDS.sleep(3L);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            boolean allHit = true;
            for (Map.Entry<String, PaymentCallbackService> entry : INSTANCE_MAP.entrySet()) {
                log.info("\u8ba2\u5355\u7c7b\u578b[{}]\u8fdb\u884c\u7ed1\u5b9a\u64cd\u4f5c", (Object)entry.getKey());
                PaymentFacadeService paymentFacadeService = (PaymentFacadeService)SpringContextHolder.getBean(PaymentFacadeService.class);
                PaymentCallbackService paymentCallbackService = entry.getValue();
                List<BindAccountRelation> bindAccountRelations = paymentCallbackService.bindRelation();
                if (!CollectionUtil.isNotEmpty(bindAccountRelations)) continue;
                Message message = paymentFacadeService.register(entry.getKey(), bindAccountRelations);
                if (null == message || !message.isSuccess()) {
                    allHit = false;
                    continue;
                }
                log.info("\u8ba2\u5355\u652f\u4ed8\u670d\u52a1\u6ce8\u518c\u6210\u529f\uff0c\u8ba2\u5355\u7c7b\u578b\uff1a{},\u573a\u666f\u7ed1\u5b9a\uff1a{}", (Object)entry.getKey(), (Object)JSON.toJSONString(bindAccountRelations));
            }
            if (allHit) break;
            --retryTime;
        }
        log.info("\u7ed1\u5b9a\u8ba2\u5355\u8d26\u53f7\u670d\u52a1\u5b8c\u6210");
    }
}

