package com.bxm.thirdparty.platform.facade.enums;

import com.bxm.thirdparty.platform.facade.notify.RefundNotifyResponse;
import com.bxm.thirdparty.platform.facade.notify.PaymentNotifyResponse;
import com.bxm.thirdparty.platform.facade.request.*;
import lombok.Getter;

import java.util.Objects;

/**
 * 通知的请求体和返回体关联枚举
 * <p>
 * 例如：
 * 通知类型为PAYMENT，则业务方可以通过此枚举得知返回体具体信息
 * 例如：
 * 通知类型为PAYMENT，通知失败，则内部封装服务可以通过重试得知具体请求体
 *
 * @author lowi
 * @date 2023/4/5 16:45
 */
@Getter
public enum NotifyTypeEnum {
    /**
     * 支付
     */
    PAYMENT(PaymentPreRequest.class, PaymentNotifyResponse.class),
    /**
     * 提现
     */
    WITHDRAW(WithdrawRequest.class, null),
    /**
     * 退款
     */
    REFUND(PaymentRefundRequest.class, RefundNotifyResponse.class),
    /**
     * 话费
     */
    CHARGE_PHONE(ChargePhoneRequest.class, null),
    /**
     * 电费
     */
    ELECTRIC(ElectricRequest.class, null),
    ;

    /**
     * 请求类
     */
    private Class<?> requestClass;

    /**
     * 返回类
     */
    private Class<?> responseClass;


    NotifyTypeEnum(Class<?> requestClass, Class<?> responseClass) {
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static NotifyTypeEnum getType(String classSimpleName) {
        for (NotifyTypeEnum value : values()) {
            if (Objects.equals(classSimpleName, value.getRequestClass().getSimpleName())) {
                return value;
            }
        }
        return null;
    }

    public static NotifyTypeEnum getRequestClass(String type) {
        for (NotifyTypeEnum value : values()) {
            if (Objects.equals(type, value.name())) {
                return value;
            }
        }
        return null;
    }
}
