package com.bxm.thirdparty.platform.facade.register;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.bxm.thirdparty.platform.facade.service.RegisterNotifyService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author lowi
 * @date 2023/3/31 16:14
 */
@Component
@Slf4j
public class RegisterRunner implements ApplicationRunner, ApplicationContextAware {

    private ApplicationContext applicationContext;

    private final String TEST_REGISTER_URL = "https://test.91huola.com:16001/v1/3rd/register/notify";

    private final String LOCAL_REGISTER_URL = "http://dev.91huola.com:16001/v1/3rd/register/notify";

    private final String PRO_REGISTER_URL = "https://api-3rd.91huola.com/v1/3rd/register/notify";

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {

        Map<String, RegisterNotifyService> beansOfType = applicationContext.getBeansOfType(RegisterNotifyService.class);
        if (beansOfType.size() == 0) {

            log.error("内部服务注册失败，请实现RegisterService接口");
            return;
        }
        if (beansOfType.size() > 1) {
            log.error("内部服务注册失败，保证实现RegisterService接口类 <=1 个");
            return;
        }
        RegisterNotifyService bean = applicationContext.getBean(RegisterNotifyService.class);
        String application = bean.application();
        String notifyUrl = bean.notifyUrl();
        if (StringUtils.isEmpty(application) || StringUtils.isEmpty(notifyUrl)) {
            log.error("内部服务注册失败，请配置applicationName和通知地址");
            return;
        }
        String registerUrl;
        Environment environment = applicationContext.getEnvironment();
        String[] activeProfiles = environment.getActiveProfiles();
        if (Objects.equals(activeProfiles[0], "PRO")) {
            registerUrl = PRO_REGISTER_URL;
        } else if (Objects.equals(activeProfiles[0], "FAT")) {
            registerUrl = TEST_REGISTER_URL;
        } else {
            registerUrl = LOCAL_REGISTER_URL;
        }

        HttpRequest httpRequest = HttpUtil.createPost(registerUrl);
        httpRequest.contentType("application/json");
        Map<String, Object> map = new HashMap<>();
        map.put("applicationName", application);
        map.put("notifyUrl", notifyUrl);
        StringBuilder jsonStr = new StringBuilder();
        StringBuilder append = jsonStr.append("{").append("\"").append("applicationName")
                .append("\":").append("\"").append(application).append("\",")
                .append("\"").append("notifyUrl")
                .append("\":").append("\"").append(notifyUrl).append("\"}");
        httpRequest.body(append.toString());
        try {
            HttpResponse execute = httpRequest.execute();
            if (execute.isOk()) {
                log.info("内部服务注册成功application：{},notifyUrl :{},body:{}", application, notifyUrl, execute.body());
            }
        } catch (Exception e) {
            log.error("内部服务注册失败:", e);
        }
    }
}
