package com.bxm.thirdparty.platform.facade.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author lowi
 * @date 2023/3/24 10:53
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ElectricRequest extends BaseRequest {

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 账户
     */
    private String account;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 南方电网需要此信息  广东/广西/云南/贵州/海南
     * 电费验证三要素，1-身份证，2-银行卡,3-营业执照
     */
    private Integer certType;

    /**
     * 南方电网需要此信息验证三要素，1-身份证后6位，2-银行卡后6位,3-营业执照后6位
     */
    private String certNo;

    /**
     * 渠道，暂只支持LI_BA,GONG_MAO_ELECTRIC
     */
    private String channel;
}
