package com.bxm.thirdparty.platform.facade.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author lowi
 * @date 2023/3/24 10:53
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WithdrawRequest extends BaseRequest {

    /**
     * 提现平台 ALI  WX
     */
    private String payPlatform;

    /**
     * 被提现的商户id
     */
    private String accountId;

    /**
     * 订单编号
     */
    private String orderNo;


    /**
     * 提现金额
     */
    private BigDecimal amount;

    /**
     * 提现备注信息
     */
    private String remark;

    /**
     * 提现显示的标题
     */
    private String title;

    /**
     * 请求来源IP
     */
    private String requestIp;


    /**
     * 用户唯一标志，ALI平台 则为阿里账户
     * WX则为openId
     */
    private String identity;

    /**
     * ALI提现需要提供用户真实姓名
     */
    private String realName;

    /**
     * wx提现需要提供appId
     */
    private String appId;

    private Long time;
}
