package com.bxm.thirdparty.platform.facade.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author lowi
 * @date 2023/3/24 10:53
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PaymentPreRequest extends BaseRequest {

    /**
     * 支付平台现支持ALI,WX,UMS
     */
    private String payPlatform;

    /**
     * 支付模型，H5,APPLET(平台为阿里的则为快应用支付，平台为微信则为小程序支付),JSAPI,APP,其他平台则为COMMON或者不传
     */
    private String payMode;

    /**
     * 订单id
     */
    private String orderNo;

    /**
     * 支付收款的账户
     */
    private String accountId;

    /**
     * 支付金额
     */
    private BigDecimal amount;


    /**
     * 支付请求IP
     */
    private String requestIp;

    /**
     * 支付成功后的跳转地址
     */
    private String returnUrl;

    /**
     * 用户取消支付后的跳转地址
     */
    private String quitUrl;

    /**
     * 微信小程序支付需要
     */
    private String appId;

    /**
     * 微信小程序支付需要
     */
    private String openId;

    /**
     * 订单标题
     */
    private String title;

    /**
     * 订单描述信息，给用户支付的时候看
     */
    private String orderDescription;
}
